/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.web.utils;

import com.google.common.base.Preconditions;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServletContextHolder {
    private static final Logger log = Logger.getLogger(ServletContextHolder.class);
    private static ServletContext servletContext;

    private ServletContextHolder() {
    }

    public static void set(@NotNull ServletContext servletContext) {
        log.info((Object)("Setting servlet context: " + servletContext.getServletContextName()));
        Preconditions.checkNotNull((Object)servletContext);
        ServletContextHolder.servletContext = servletContext;
    }

    @NotNull
    public static ServletContext get() {
        Preconditions.checkState((servletContext != null ? 1 : 0) != 0, (Object)"ServletContext not available");
        return servletContext;
    }

    @Nullable
    public static WebApplicationContext getWebApplicationContext() {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
    }
}

