/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.web.utils;

import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.web.utils.UploadedFile;
import com.atlassian.bamboo.web.utils.UploadedFileImpl;
import com.atlassian.bamboo.web.utils.UploadedFileManager;
import com.atlassian.bamboo.web.utils.UploadedFileManagerException;
import com.atlassian.config.HomeLocator;
import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.jetbrains.annotations.NotNull;

public class UploadedFileManagerImpl
implements UploadedFileManager {
    private static final Logger log = Logger.getLogger(UploadedFileManagerImpl.class);
    public static final int DEFAULT_MAX_UPLOADED_FILE_SIZE_MB = 50;
    private static final String UPLOADED_FILES_DIR = "uploadedFiles";
    private final HomeLocator homeLocator;
    private final SecureRandomService random = DefaultSecureRandomService.getInstance();

    public UploadedFileManagerImpl(HomeLocator homeLocator) {
        this.homeLocator = homeLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UniqueFile createUniqueFile(String fileName) throws IOException {
        String string = fileName.intern();
        synchronized (string) {
            long uniqueId;
            File savedUploadedFile;
            File uploadedFilesDir = this.getUploadedFilesDirectory();
            while ((savedUploadedFile = new File(uploadedFilesDir, (uniqueId = this.random.nextLong()) + "_" + fileName)).exists()) {
            }
            return new UniqueFile(savedUploadedFile, uniqueId);
        }
    }

    @NotNull
    public UploadedFile createFile(@NotNull MultiPartRequestWrapper requestWrapper, @NotNull String fileParamName) throws UploadedFileManagerException {
        this.validateFile(requestWrapper, fileParamName);
        org.apache.struts2.dispatcher.multipart.UploadedFile[] files = requestWrapper.getFiles(fileParamName);
        if (files == null || files.length == 0) {
            throw new UploadedFileManagerException(String.format("Could not create file. No file found in MultiPartRequestWrapper. File param name: %s.", fileParamName));
        }
        try {
            String name = requestWrapper.getFileNames(fileParamName)[0];
            UniqueFile uniqueFile = this.createUniqueFile(name);
            FileUtils.moveFile((File)new File(files[0].getAbsolutePath()), (File)uniqueFile.getFile());
            return new UploadedFileImpl(name, uniqueFile.getFile());
        }
        catch (IOException e) {
            throw new UploadedFileManagerException("Error saving uploaded file ", (Throwable)e);
        }
    }

    @NotNull
    public UploadedFile createFile(@NotNull InputStream inputStream, @NotNull String fileName, @NotNull String contentType, long size) throws UploadedFileManagerException {
        if (size < 0L) {
            throw new IllegalArgumentException("size must be >= 0.");
        }
        if (size == 0L) {
            throw new UploadedFileManagerException("Size of " + fileName + " is zero");
        }
        long maxAttachmentSize = this.getMaximumUploadedFileSizeBytes();
        if (size > maxAttachmentSize) {
            throw new UploadedFileManagerException("Size of " + fileName + " exceeds maximum allowed size (" + maxAttachmentSize + ")");
        }
        try {
            UniqueFile uniqueFile = this.createUniqueFile(fileName);
            try (FileOutputStream fos = new FileOutputStream(uniqueFile.getFile());){
                long copiedSize = IOUtils.copyLarge((InputStream)inputStream, (OutputStream)fos);
                if (size != copiedSize) {
                    throw new UploadedFileManagerException("Declared size is " + size + " while source stream size is " + copiedSize);
                }
            }
            return new UploadedFileImpl(fileName, uniqueFile.getFile());
        }
        catch (IOException e) {
            throw new UploadedFileManagerException("Error saving uploaded file", (Throwable)e);
        }
    }

    public long getMaximumUploadedFileSizeBytes() {
        return (long)SystemProperty.FILE_UPLOAD_MAXIMUM_SIZE.getValue(50) * 0x100000L;
    }

    public void validateFile(MultiPartRequestWrapper requestWrapper, String fileParamName) throws UploadedFileManagerException {
        if (StringUtils.isBlank((CharSequence)fileParamName)) {
            throw new UploadedFileManagerException("Parameter undefined");
        }
        long size = requestWrapper.getContentLength();
        if (size < 0L) {
            throw new UploadedFileManagerException("Size was not sent with request");
        }
        long maximumSize = this.getMaximumUploadedFileSizeBytes();
        if (size > maximumSize) {
            throw new UploadedFileManagerException("Size of the file exceeds maximum allowed size (" + maximumSize + ")");
        }
    }

    @NotNull
    public File getUploadedFilesDirectory() {
        File uploadedFileDir = new File(this.homeLocator.getHomePath(), UPLOADED_FILES_DIR);
        uploadedFileDir.mkdir();
        return uploadedFileDir;
    }

    static class UniqueFile {
        private final File file;
        private final long id;

        UniqueFile(File file, long id) {
            this.file = file;
            this.id = id;
        }

        public File getFile() {
            return this.file;
        }

        public long getId() {
            return this.id;
        }
    }
}

