/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webrepository;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.deployments.versions.history.commit.DeploymentVersionVcsCommit;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.cvsimpl.CVSRepository;
import com.atlassian.bamboo.repository.perforce.PerforceRepository;
import com.atlassian.bamboo.repository.svn.SvnRepository;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.webrepository.AbstractWebRepositoryViewer;
import com.atlassian.bamboo.webrepository.DeploymentsAwareCommitUrlProvider;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.opensymphony.util.UrlUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class DefaultWebRepositoryViewer
extends AbstractWebRepositoryViewer
implements DeploymentsAwareCommitUrlProvider {
    private static final Logger log = Logger.getLogger(DefaultWebRepositoryViewer.class);
    private static final String FULL_COMMIT_VIEW_TEMPLATE = "templates/plugins/webRepository/defaultCommitView.ftl";
    private static final String SUMMARY_COMMIT_VIEW_TEMPLATE = "templates/plugins/webRepository/commonCommitSummaryView.ftl";
    public static final String WEB_REPOSITORY_URL = "webRepository.genericRepositoryViewer.webRepositoryUrl";
    public static final String WEB_REPOSITORY_NAME = "webRepository.genericRepositoryViewer.webRepositoryUrlRepoName";
    private static final String DOT = ".";
    private String webRepositoryUrl;
    private String webRepositoryName;
    private final List<String> supportedRepositories = Lists.newArrayList((Object[])new String[]{"com.atlassian.bamboo.plugin.system.repository:svn", "com.atlassian.bamboo.plugin.system.repository:cvs", "com.atlassian.bamboo.plugin.system.repository:p4"});
    @Inject
    @VisibleForTesting
    transient VariableSubstitutorFactory variableSubstitutorFactory;

    @Override
    @NotNull
    public Collection<String> getSupportedRepositories() {
        return this.supportedRepositories;
    }

    public String getHtmlForCommitsFull(@NotNull ResultsSummary resultsSummary, @NotNull RepositoryChangeset repositoryChangeset, @NotNull RepositoryData repositoryData) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("buildResultsSummary", resultsSummary);
        context.put("repositoryChangeset", repositoryChangeset);
        context.put("repositoryData", repositoryData);
        context.put("linkGenerator", this);
        return this.templateRenderer.render(FULL_COMMIT_VIEW_TEMPLATE, context);
    }

    public String getHtmlForCommitsSummary(@NotNull ResultsSummary resultsSummary, @NotNull RepositoryChangeset repositoryChangeset, @NotNull RepositoryData repositoryData, int maxChanges) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("buildResultsSummary", resultsSummary);
        context.put("repositoryChangeset", repositoryChangeset);
        context.put("repositoryData", repositoryData);
        context.put("linkGenerator", this);
        context.put("maxChanges", maxChanges);
        return this.templateRenderer.render(SUMMARY_COMMIT_VIEW_TEMPLATE, context);
    }

    @Override
    public void populateFromParams(@NotNull ActionParametersMap params) {
        this.setWebRepositoryUrl(params.getString(WEB_REPOSITORY_URL));
        this.setWebRepositoryName(params.getString(WEB_REPOSITORY_NAME));
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.setWebRepositoryUrl(config.getString(WEB_REPOSITORY_URL));
        this.setWebRepositoryName(config.getString(WEB_REPOSITORY_NAME));
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty(WEB_REPOSITORY_NAME, (Object)this.getWebRepositoryName());
        configuration.setProperty(WEB_REPOSITORY_URL, (Object)com.atlassian.bamboo.util.UrlUtils.correctlyFormatUrl((String)this.getWebRepositoryUrl()));
        return configuration;
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        String url = this.substituteVariables(buildConfiguration.getString(WEB_REPOSITORY_URL));
        if (StringUtils.isNotBlank((CharSequence)url) && !UrlUtils.verifyHierachicalURI((String)url)) {
            errorCollection.addError(WEB_REPOSITORY_URL, "This is not a valid url");
        }
        return errorCollection;
    }

    @Nullable
    private String substituteVariables(@Nullable String webRepositoryUrl) {
        return this.newVariableSubstitutor().substituteString(webRepositoryUrl);
    }

    @NotNull
    VariableSubstitutor newVariableSubstitutor() {
        return this.variableSubstitutorFactory.newSubstitutorForGlobalContext();
    }

    @Nullable
    public String getWebRepositoryUrlForFile(@NotNull CommitFile file, RepositoryData repositoryData) {
        if (this.webRepositoryUrl == null) {
            log.error((Object)("Web url is not defined. Can not generate web repository urls for file: " + file.getName()));
            return null;
        }
        VariableSubstitutor variableSubstitutor = this.newVariableSubstitutor();
        String substitutedWebUrl = variableSubstitutor.substituteString(this.webRepositoryUrl);
        if (substitutedWebUrl == null) {
            log.warn((Object)("Variable substitution failed for web url '" + this.webRepositoryUrl + "', using original url."));
            substitutedWebUrl = this.webRepositoryUrl;
        }
        StringBuilder result = new StringBuilder(substitutedWebUrl);
        String substitutedWebName = variableSubstitutor.substituteString(this.webRepositoryName);
        String fileName = StringUtils.removeStart((String)file.getName(), (String)substitutedWebName);
        if (!substitutedWebUrl.endsWith("/") && !fileName.startsWith("/")) {
            result.append('/');
        } else if (substitutedWebUrl.endsWith("/") && fileName.startsWith("/")) {
            result.deleteCharAt(result.length() - 1);
        }
        result.append(fileName).append("?");
        result.append("content-type=text/vnd.viewcvs-markup");
        if (StringUtils.isNotBlank((CharSequence)substitutedWebName)) {
            Repository repository = repositoryData.getRepository();
            if (repository instanceof SvnRepository) {
                result.append("&root=").append(substitutedWebName);
            } else if (repository instanceof CVSRepository) {
                result.append("&cvsroot=").append(substitutedWebName);
            } else if (repository instanceof PerforceRepository) {
                // empty if block
            }
        }
        return StringUtils.replace((String)result.toString(), (String)"/Attic", (String)"");
    }

    @Nullable
    public String getWebRepositoryUrlForRevision(CommitFile file, RepositoryData repositoryData) {
        String urlForFile = this.getWebRepositoryUrlForFile(file, repositoryData);
        if (StringUtils.isBlank((CharSequence)urlForFile)) {
            return null;
        }
        StringBuilder result = new StringBuilder(urlForFile);
        if (file.isRevisionKnown()) {
            String revision = file.getRevision();
            result.append("&revision=").append(revision);
            result.append("&r=").append(revision);
            result.append("#r").append(revision);
        }
        return result.toString();
    }

    @Nullable
    public String getWebRepositoryUrlForDiff(CommitFile file, RepositoryData repositoryData) {
        String revision;
        String previousRevision;
        String urlForFile = this.getWebRepositoryUrlForFile(file, repositoryData);
        if (StringUtils.isBlank((CharSequence)urlForFile)) {
            return null;
        }
        StringBuilder result = new StringBuilder(urlForFile);
        if (file.isRevisionKnown() && (previousRevision = this.getPreviousRevision(revision = file.getRevision())) != null) {
            result.append("&r1=").append(previousRevision).append("&r2=").append(revision);
        }
        return result.toString();
    }

    public Map<Commit, String> getWebRepositoryUrlForCommits(Collection<Commit> commits, RepositoryData repositoryDefinition) {
        HashMap<Commit, String> commitsToUrls = new HashMap<Commit, String>();
        String changeLogPrefix = this.getFishEyeChangeSetPrefix();
        if (changeLogPrefix != null) {
            for (Commit commit : commits) {
                String cs;
                Repository repository = repositoryDefinition.getRepository();
                if (!(repository instanceof SvnRepository) && !(repository instanceof PerforceRepository) || (cs = commit.guessChangeSetId()) == null) continue;
                commitsToUrls.put(commit, changeLogPrefix + "?cs=" + cs);
            }
        }
        return commitsToUrls;
    }

    public Map<DeploymentVersionVcsCommit, String> getWebRepositoryUrlForDeploymentVersionCommits(Collection<DeploymentVersionVcsCommit> commits, RepositoryData repositoryData) {
        HashMap<DeploymentVersionVcsCommit, String> commitsToUrls = new HashMap<DeploymentVersionVcsCommit, String>();
        String changeLogPrefix = this.getFishEyeChangeSetPrefix();
        if (changeLogPrefix != null) {
            for (DeploymentVersionVcsCommit commit : commits) {
                String cs;
                Repository repository = repositoryData.getRepository();
                if (!(repository instanceof SvnRepository) && !(repository instanceof PerforceRepository) || (cs = commit.getChangeSetId()) == null) continue;
                commitsToUrls.put(commit, changeLogPrefix + "?cs=" + cs);
            }
        }
        return commitsToUrls;
    }

    @Nullable
    public String getWebRepositoryUrlForCommit(Commit commit, @NotNull RepositoryData repositoryData) {
        Map<Commit, String> commitsToUrls = this.getWebRepositoryUrlForCommits(Arrays.asList(commit), repositoryData);
        return commitsToUrls.isEmpty() ? null : commitsToUrls.get(commit);
    }

    public String getWebRepositoryUrlForRevision(String revisionId, @NotNull RepositoryData repositoryDefinition) {
        return null;
    }

    @Nullable
    private String getFishEyeChangeSetPrefix() {
        String substitutedWebUrl = this.substituteVariables(this.webRepositoryUrl);
        if (StringUtils.isBlank((CharSequence)substitutedWebUrl)) {
            return null;
        }
        if (substitutedWebUrl.endsWith("/browse")) {
            return substitutedWebUrl.replaceAll("/browse$", "/changelog");
        }
        if (substitutedWebUrl.endsWith("/viewrep")) {
            return substitutedWebUrl.replaceAll("/viewrep$", "/changelog");
        }
        if (substitutedWebUrl.contains("/browse/")) {
            return substitutedWebUrl.replaceFirst("/browse/", "/changelog/");
        }
        if (substitutedWebUrl.contains("/viewrep/")) {
            return substitutedWebUrl.replaceFirst("/viewrep/", "/changelog/");
        }
        return null;
    }

    @Nullable
    String getPreviousRevision(String revision) {
        if (StringUtils.contains((CharSequence)revision, (CharSequence)DOT)) {
            String suffix = StringUtils.substringAfterLast((String)revision, (String)DOT);
            try {
                long revSuffix = Long.parseLong(suffix);
                if (revSuffix > 0L) {
                    String prefix = StringUtils.substringBeforeLast((String)revision, (String)DOT);
                    return prefix + DOT + --revSuffix;
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Unable to parse revision for WebRepositoryUrl: " + revision));
            }
        } else {
            try {
                long revNum = Long.parseLong(revision);
                if (revNum > 0L) {
                    return String.valueOf(--revNum);
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Unable to parse revision for WebRepositoryUrl: " + revision));
            }
        }
        return null;
    }

    public String getWebRepositoryUrl() {
        return this.webRepositoryUrl;
    }

    public void setWebRepositoryUrl(String webRepositoryUrl) {
        this.webRepositoryUrl = StringUtils.defaultString((String)webRepositoryUrl).trim();
    }

    public String getWebRepositoryName() {
        return this.webRepositoryName;
    }

    public void setWebRepositoryName(String webRepositoryName) {
        this.webRepositoryName = StringUtils.defaultString((String)webRepositoryName).trim();
    }
}

