/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webrepository;

import com.atlassian.bamboo.plugin.descriptor.WebRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.WebRepositoryViewerModuleDescriptorImpl;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.webrepository.WebRepositoryViewerManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRepositoryViewerManagerImpl
implements WebRepositoryViewerManager {
    private static final Logger log = Logger.getLogger(WebRepositoryViewerManagerImpl.class);
    private PluginAccessor pluginAccessor;

    @NotNull
    public List<WebRepositoryViewerModuleDescriptor> getWebRepositoryViewerModuleDescriptors() {
        return new ArrayList<WebRepositoryViewerModuleDescriptor>(this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebRepositoryViewerModuleDescriptorImpl.class));
    }

    @NotNull
    public List<WebRepositoryViewer> getWebRepositoryViewers() {
        Predicate<WebRepositoryViewer> isNoRepositoryViewer = webRepositoryViewer -> "noRepositoryViewer".equals(webRepositoryViewer.getShortKey());
        return this.pluginAccessor.getEnabledModulesByClass(WebRepositoryViewer.class).stream().sorted(Comparator.comparing(isNoRepositoryViewer::test)).collect(Collectors.toList());
    }

    @Nullable
    public WebRepositoryViewer getNewWebRepositoryViewerInstance(@Nullable String key) {
        if (key != null) {
            ModuleDescriptor pluginModuleDescriptor = this.pluginAccessor.getPluginModule(key);
            if (pluginModuleDescriptor == null) {
                log.error((Object)("Could not find web repository viewer with key '" + key + "'."));
                return null;
            }
            return (WebRepositoryViewer)pluginModuleDescriptor.getModule();
        }
        log.warn((Object)"Key passed was null. A null web repository viewer being returned");
        return null;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

