/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.webwork;

import com.atlassian.bamboo.plugin.xwork.XWorkModuleDescriptor;
import com.atlassian.config.util.BootstrapUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.ContainerProvider;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.Dispatcher;
import org.jetbrains.annotations.NotNull;

public class Dispatchers {
    private static final List<ContainerProvider> CONFIGURATION_PROVIDERS = new CopyOnWriteArrayList<ContainerProvider>();
    private static final List<Dispatcher> DISPATCHERS = new CopyOnWriteArrayList<Dispatcher>();
    private static final Logger log = Logger.getLogger(Dispatchers.class);
    private final Function<Object, ManagedLock> lockFactory = ManagedLocks.weakManagedLockFactory();

    public void add(Dispatcher du) {
        log.info((Object)("Dispatcher " + du.getClass().getCanonicalName() + " initialised"));
        ConfigurationManager configurationManager = du.getConfigurationManager();
        this.flushPendingUpdates(configurationManager);
        DISPATCHERS.add(du);
        this.lockFactory.apply(configurationManager).withLock(() -> ((ConfigurationManager)configurationManager).reload());
        String multiPartSaveDir = (String)BootstrapUtils.getBootstrapManager().getProperty("webwork.multipart.saveDir");
        if (!Strings.isNullOrEmpty((String)multiPartSaveDir)) {
            du.setMultipartSaveDir(multiPartSaveDir);
        }
    }

    public void remove(Dispatcher du) {
        log.info((Object)("Dispatcher " + du.getClass().getCanonicalName() + " destroyed"));
        DISPATCHERS.remove(du);
    }

    private void flushPendingUpdates(ConfigurationManager configurationManager) {
        ArrayList newContainerProviders = Lists.newArrayList((Iterable)configurationManager.getContainerProviders());
        ArrayList pendingConfigurationProviders = Lists.newArrayList(CONFIGURATION_PROVIDERS);
        newContainerProviders.removeAll(pendingConfigurationProviders);
        newContainerProviders.addAll(pendingConfigurationProviders);
        this.lockFactory.apply(configurationManager).withLock(() -> configurationManager.setContainerProviders(newContainerProviders));
    }

    public Collection<ConfigurationManager> addContainerProvider(ConfigurationProvider configurationProvider) {
        Collection<ConfigurationManager> configurationManagers = this.getConfigurationManagers();
        if (configurationManagers.isEmpty()) {
            CONFIGURATION_PROVIDERS.add((ContainerProvider)configurationProvider);
            return configurationManagers;
        }
        for (ConfigurationManager configurationManager : configurationManagers) {
            this.lockFactory.apply(configurationManager).withLock(() -> configurationManager.addContainerProvider((ContainerProvider)configurationProvider));
        }
        return configurationManagers;
    }

    public void removeContainerProvider(ConfigurationProvider configurationProvider) {
        Collection<ConfigurationManager> configurationManagers = this.getConfigurationManagers();
        if (configurationManagers.isEmpty()) {
            CONFIGURATION_PROVIDERS.remove(configurationProvider);
            return;
        }
        for (ConfigurationManager configurationManager : configurationManagers) {
            this.removeConfigurationProvider(configurationManager, configurationProvider);
        }
    }

    private void removeConfigurationProvider(final ConfigurationManager configurationManager, final ConfigurationProvider configurationProvider) {
        this.lockFactory.apply(configurationManager).withLock(new Runnable(){

            @Override
            public void run() {
                ArrayList providers = Lists.newArrayList((Iterable)configurationManager.getContainerProviders());
                providers.remove(configurationProvider);
                configurationManager.setContainerProviders((List)providers);
            }
        });
    }

    @NotNull
    public Collection<ConfigurationManager> getConfigurationManagers() {
        return DISPATCHERS.stream().map(Dispatcher::getConfigurationManager).collect(Collectors.toList());
    }

    public void reload() {
        for (ConfigurationManager configurationManager : this.getConfigurationManagers()) {
            this.lockFactory.apply(configurationManager).withLock(() -> ((ConfigurationManager)configurationManager).reload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceContainerProvider(final XWorkModuleDescriptor xwork) {
        for (final ConfigurationManager configurationManager : this.getConfigurationManagers()) {
            this.lockFactory.apply(configurationManager).withLock(new Runnable(){

                @Override
                public void run() {
                    Dispatchers.this.removeConfigurationProvider(configurationManager, xwork);
                    configurationManager.addContainerProvider((ContainerProvider)xwork);
                }
            });
        }
        List<ContainerProvider> list = CONFIGURATION_PROVIDERS;
        synchronized (list) {
            CONFIGURATION_PROVIDERS.remove((Object)xwork);
            CONFIGURATION_PROVIDERS.add((ContainerProvider)xwork);
        }
    }
}

