/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp;

import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerDefinition;
import com.atlassian.bamboo.instantmessagingserver.InstantMessagingServerManager;
import com.atlassian.bamboo.security.ssl.LoggingHostNameVerifier;
import com.atlassian.bamboo.util.concurrent.BlockingCircularFifoQueue;
import com.atlassian.bamboo.xmpp.LoggingSSLSocketFactory;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.springframework.beans.factory.InitializingBean;

public class BambooSmackClient
implements InitializingBean {
    private static final Logger log = Logger.getLogger(BambooSmackClient.class);
    public static final String DEFAULT_RESOURCE = "Bamboo";
    private static final Integer DEFAULT_TLS_PORT = 5222;
    private static final Integer DEFAULT_SSL_PORT = 5223;
    private final InstantMessagingServerManager instantMessagingServerManager;
    private final BambooXMPPConnection connection;
    private static final int USER_MESSAGE_CONTEXT_SIZE = 50;
    private final MessageContexts userMessageContexts = new MessageContexts(50);
    private final BlockingCircularFifoQueue<Message> messageQueue = new BlockingCircularFifoQueue(100);
    private final boolean isNotificationSystemDisabled = Boolean.parseBoolean(System.getProperty("atlassian.mail.senddisabled"));

    public BambooSmackClient(InstantMessagingServerManager instantMessagingServerManager) {
        if (this.isNotificationSystemDisabled) {
            log.info((Object)"No notifications sent due to flag -Datlassian.mail.senddisabled=true");
            this.instantMessagingServerManager = null;
            this.connection = new BambooXMPPConnection(null);
        } else {
            this.instantMessagingServerManager = instantMessagingServerManager;
            this.connection = new BambooXMPPConnection(instantMessagingServerManager);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.isNotificationSystemDisabled) {
            XmppWorkerThread xmppWorkerThread = new XmppWorkerThread(this.messageQueue, this.connection);
            xmppWorkerThread.start();
        }
    }

    public void connect(@Nullable InstantMessagingServerDefinition instantMessagingServerDefinition) throws XMPPException, IOException, SmackException {
        if (instantMessagingServerDefinition == null || Boolean.parseBoolean(System.getProperty("atlassian.mail.senddisabled"))) {
            log.info((Object)"No IM server specified. Bamboo Smack client not initialised.");
            return;
        }
        this.connection.createNewConnection(instantMessagingServerDefinition);
    }

    public void connect() throws XMPPException, IOException, SmackException {
        this.connect(BambooSmackClient.getMessagingServerDefinition(this.instantMessagingServerManager));
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public void send(Message message) {
        this.messageQueue.put(message);
    }

    public Map<String, String> getMessageContextForUser(String jabberAddress) {
        return this.userMessageContexts.get(jabberAddress);
    }

    public void putUserMessageContext(String jabberAddress, Map<String, String> context) {
        this.userMessageContexts.put(jabberAddress, context);
    }

    @Nullable
    private static InstantMessagingServerDefinition getMessagingServerDefinition(InstantMessagingServerManager instantMessagingServerManager) {
        return (InstantMessagingServerDefinition)Iterables.getFirst((Iterable)instantMessagingServerManager.getAllInstantMessagingServers(), null);
    }

    public void setMessageListener(StanzaListener messageListener) {
        this.connection.setMessageListener(messageListener);
    }

    private static class XmppWorkerThread
    extends Thread {
        private final BlockingCircularFifoQueue<Message> messageQueue;
        private final BambooXMPPConnection connection;

        public XmppWorkerThread(BlockingCircularFifoQueue<Message> messageQueue, BambooXMPPConnection connection) {
            super("XMPP Worker");
            this.messageQueue = messageQueue;
            this.connection = connection;
        }

        @Override
        public void run() {
            while (!XmppWorkerThread.interrupted()) {
                try {
                    Message message = this.messageQueue.take();
                    this.connection.syncSend(message);
                }
                catch (RuntimeException e) {
                    log.error((Object)"Unexpected exception", (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.error((Object)"XMPP thread interrupted, terminating", (Throwable)e);
                    break;
                }
            }
        }
    }

    static class BambooXMPPConnection {
        private AbstractXMPPConnection xmppConnection;
        private final InstantMessagingServerManager instantMessagingServerManager;
        private StanzaListener currentStanzaListener;

        BambooXMPPConnection(InstantMessagingServerManager instantMessagingServerManager) {
            this.instantMessagingServerManager = instantMessagingServerManager;
        }

        synchronized AbstractXMPPConnection createNewConnection(@NotNull InstantMessagingServerDefinition server) throws XMPPException, IOException, SmackException {
            log.info((Object)("Connecting to " + server));
            this.disconnect();
            String host = server.getHost();
            String serviceName = "talk.google.com".equals(host) ? "gmail.com" : host;
            Integer port = server.getPort();
            XMPPTCPConnectionConfiguration.Builder connectionConfigurationBuilder = XMPPTCPConnectionConfiguration.builder();
            ConnectionConfiguration.SecurityMode securityMode = ConnectionConfiguration.SecurityMode.ifpossible;
            if (server.isSecureConnectionRequired()) {
                if (port == null) {
                    port = server.isEnforceLegacySsl() ? DEFAULT_SSL_PORT : DEFAULT_TLS_PORT;
                }
                ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)connectionConfigurationBuilder.setHost(host)).setPort(port.intValue())).setServiceName(serviceName);
                if (server.isEnforceLegacySsl()) {
                    connectionConfigurationBuilder.setSocketFactory((SocketFactory)new LoggingSSLSocketFactory());
                    connectionConfigurationBuilder.setHostnameVerifier((HostnameVerifier)new LoggingHostNameVerifier("Smack client", SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER));
                } else {
                    securityMode = ConnectionConfiguration.SecurityMode.required;
                    connectionConfigurationBuilder.setHostnameVerifier((HostnameVerifier)new LoggingHostNameVerifier("Smack client", SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER));
                }
            } else if (port != null) {
                ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)connectionConfigurationBuilder.setHost(host)).setPort(port.intValue())).setServiceName(serviceName);
            } else {
                connectionConfigurationBuilder.setServiceName(serviceName);
            }
            connectionConfigurationBuilder.setSecurityMode(securityMode);
            this.xmppConnection = new XMPPTCPConnection(connectionConfigurationBuilder.build());
            this.xmppConnection.connect();
            String resource = (String)StringUtils.defaultIfEmpty((CharSequence)server.getResource(), (CharSequence)BambooSmackClient.DEFAULT_RESOURCE);
            this.xmppConnection.login((CharSequence)server.getUsername(), server.getPassword(), resource);
            this.addMessageListener(this.currentStanzaListener);
            return this.xmppConnection;
        }

        public synchronized void setMessageListener(@NotNull StanzaListener newListener) {
            if (this.xmppConnection != null) {
                this.xmppConnection.removeSyncStanzaListener(this.currentStanzaListener);
                this.addMessageListener(newListener);
            }
            this.currentStanzaListener = newListener;
        }

        private void addMessageListener(@Nullable StanzaListener listener) {
            if (listener != null) {
                StanzaTypeFilter filter = new StanzaTypeFilter(Message.class);
                this.xmppConnection.addSyncStanzaListener(listener, (StanzaFilter)filter);
            }
        }

        public synchronized void disconnect() {
            if (this.xmppConnection != null) {
                this.xmppConnection.disconnect();
            }
        }

        public synchronized void syncSend(Message message) {
            InstantMessagingServerDefinition messagingServerDefinition = BambooSmackClient.getMessagingServerDefinition(this.instantMessagingServerManager);
            if (messagingServerDefinition != null) {
                try {
                    this.getConnection(messagingServerDefinition).sendStanza((Stanza)message);
                }
                catch (SmackException.NotConnectedException e) {
                    log.warn((Object)"Cannot send XMPP message, not connected", (Throwable)e);
                }
            }
        }

        private XMPPConnection getConnection(@NotNull InstantMessagingServerDefinition messagingServer) {
            if (this.xmppConnection == null || !this.xmppConnection.isConnected()) {
                try {
                    this.createNewConnection(messagingServer);
                }
                catch (IOException | SmackException | XMPPException e) {
                    throw new IllegalStateException("The Bamboo Smack client could not be initiated.", e);
                }
            }
            return this.xmppConnection;
        }
    }

    private static class MessageContexts {
        private final LinkedHashMap<String, Map<String, String>> userMessageContexts = new LinkedHashMap();
        private final int maxUsers;

        public MessageContexts(int maxUsers) {
            this.maxUsers = maxUsers;
        }

        public synchronized Map<String, String> get(String jabberAddress) {
            return this.userMessageContexts.get(jabberAddress);
        }

        public synchronized void put(@NotNull String jabberAddress, Map<String, String> context) {
            if (this.userMessageContexts.size() >= this.maxUsers && this.userMessageContexts.get(jabberAddress) == null) {
                String firstUser = this.userMessageContexts.keySet().iterator().next();
                this.userMessageContexts.remove(firstUser);
            }
            this.userMessageContexts.put(jabberAddress, context);
        }
    }
}

