/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp;

import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.xmpp.BambooSmackClient;
import com.atlassian.bamboo.xmpp.SmackCommandUtils;
import com.atlassian.bamboo.xmpp.UserMessageContext;
import com.atlassian.bamboo.xmpp.commands.SmackCommand;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;

public class BambooSmackMessageListener
implements StanzaListener {
    private static final Logger log = Logger.getLogger(BambooSmackMessageListener.class);
    @Inject
    private BambooUserManager bambooUserManager;
    @Inject
    private BambooSmackClient smackClient;

    public void processPacket(Stanza stanza) {
        this.processMessage((Message)stanza);
    }

    private void processMessage(Message message) {
        if (message.getType() != Message.Type.chat || StringUtils.isBlank((CharSequence)message.getBody())) {
            return;
        }
        try {
            BambooUser user = this.bambooUserManager.findUserWithJabberAddress(message.getFrom());
            if (user == null) {
                this.sendResponse(message, "Your chat account [" + message.getFrom() + "] is not known to Bamboo. Please add it to your Bamboo profile.");
                return;
            }
            ImpersonationHelper.runAs((BambooUser)user, () -> this.handleMessage(message, user));
        }
        catch (RuntimeException e) {
            log.warn((Object)"Error with Bamboo Smack client", (Throwable)e);
            try {
                this.sendResponse(message, "An internal error has occurred in Bamboo: " + e.getMessage());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private void handleMessage(Message incomingMessage, BambooUser user) {
        UserMessageContext.Commands command;
        Map<String, String> currentUserMessageContext = this.smackClient.getMessageContextForUser(user.getJabberAddress());
        Map<String, String> commandContext = SmackCommandUtils.parseMessage(incomingMessage.getBody(), currentUserMessageContext);
        String commandString = commandContext.get("user.input");
        if (commandString == null) {
            this.sendResponse(incomingMessage, BambooSmackMessageListener.getSyntaxResponse());
            return;
        }
        try {
            command = UserMessageContext.Commands.valueOf(commandString.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            this.sendResponse(incomingMessage, BambooSmackMessageListener.getSyntaxResponse());
            return;
        }
        if (!commandContext.containsKey("plan.result.key")) {
            this.sendResponse(incomingMessage, "Invalid plan result key");
            return;
        }
        SmackCommand commandAction = command.getActionObject();
        String result = commandAction.run(commandContext, user);
        if ("SUCCESS".equals(result)) {
            this.smackClient.putUserMessageContext(user.getJabberAddress(), commandContext);
        }
        this.sendResponse(incomingMessage, commandAction.getResponseMessage());
    }

    private static String getSyntaxResponse() {
        StringBuilder sb = new StringBuilder("Invalid command. Usage:\n");
        for (UserMessageContext.Commands command : UserMessageContext.Commands.values()) {
            sb.append(command.name()).append(" ").append(command.getSyntax()).append("\n");
        }
        return sb.toString();
    }

    private void sendResponse(Message incomingMessage, String response) {
        Message responseMessage = new Message(incomingMessage.getFrom(), Message.Type.chat);
        responseMessage.setThread(incomingMessage.getThread());
        responseMessage.setBody(response);
        this.smackClient.send(responseMessage);
    }
}

