/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp;

import com.atlassian.bamboo.security.ssl.DefaultTrustManager;
import com.atlassian.security.random.SecureRandomFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;

class LoggingSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger log = Logger.getLogger(LoggingSSLSocketFactory.class);
    private SSLSocketFactory factory;

    LoggingSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new DefaultTrustManager()}, SecureRandomFactory.newInstance());
            this.factory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
        return this.factory.createSocket(socket, s, i, b);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int j) throws IOException {
        return this.factory.createSocket(inetAddress, i, inetAddress1, j);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.factory.createSocket(inetAddress, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int j) throws IOException {
        return this.factory.createSocket(s, i, inetAddress, j);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.factory.createSocket(s, i);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

