/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SmackCommandUtils {
    private static final Logger log = Logger.getLogger(SmackCommandUtils.class);

    public static Map<String, String> parseMessage(String message, Map<String, String> originalContext) {
        Map<String, String> context = SmackCommandUtils.cloneContext(originalContext);
        if (message != null && message.length() > 0) {
            String[] strings = message.split("\\s", 2);
            String commandToken = strings[0];
            context.put("user.input", commandToken.toLowerCase());
            if (strings.length > 1) {
                String possibleBuildKey;
                String remainingToken = strings[1];
                String[] secondSplit = remainingToken.split("\\s", 2);
                if (secondSplit.length > 0 && (possibleBuildKey = secondSplit[0].toUpperCase()).matches("([A-Z0-9]+-){2,3}[0-9]+")) {
                    try {
                        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)possibleBuildKey);
                        context.put("plan.result.key", planResultKey.getKey());
                        context.put("project.key", PlanKeys.getProjectKeyPart((PlanResultKey)planResultKey));
                        context.put("build.key", PlanKeys.getPlanKeyPart((PlanResultKey)planResultKey));
                        context.put("build.number", Integer.toString(planResultKey.getBuildNumber()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (secondSplit.length > 1) {
                        context.put("user.input.body", secondSplit[1]);
                        return context;
                    }
                }
                context.put("user.input.body", remainingToken);
            }
        }
        return context;
    }

    private static Map<String, String> cloneContext(Map<String, String> originalContext) {
        HashMap<Object, Object> context;
        if (originalContext != null) {
            context = new HashMap<String, String>(originalContext);
            context.remove("server.response");
            context.remove("user.input");
            context.remove("user.input.body");
        } else {
            context = new HashMap();
        }
        context.put("updated", new Date().toString());
        return context;
    }
}

