/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp;

import com.atlassian.bamboo.commonsconfig.BambooHierarchicalConfiguration;
import com.atlassian.bamboo.notification.EmailValidator;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.xmpp.XmppMessageSender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SmackXmppMessageSender
implements XmppMessageSender {
    private static final Logger log = Logger.getLogger(SmackXmppMessageSender.class);
    @Deprecated
    private transient String userRecipients;
    private boolean myIsRequired;
    private transient String myHost;
    private transient String myUsername;
    private transient String myPassword;
    private String myRecipients;
    private List groupsToNotify;
    private transient boolean mySSLRequired;

    public void setIsRequired(boolean isRequired) {
        this.myIsRequired = isRequired;
    }

    public boolean isRequired() {
        return this.myIsRequired;
    }

    public String getRecipients() {
        return this.myRecipients;
    }

    public void setRecipients(String recipients) {
        this.myRecipients = recipients;
    }

    public ErrorCollection validate() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.myIsRequired) {
            return errorCollection;
        }
        if (StringUtils.isEmpty((CharSequence)this.myRecipients) && (this.getGroupsToNotify() == null || this.getGroupsToNotify().equals(Collections.emptyList()))) {
            errorCollection.addError("xmpp.recipients", "Please specify the recipients of the build message.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.myRecipients)) {
            String[] emails;
            for (String email : emails = this.myRecipients.split(",")) {
                String s = email.trim();
                if (EmailValidator.isValidEmailAddressFormat(s)) continue;
                errorCollection.addError("xmpp.recipients", s + " is not a valid recipient.");
            }
        }
        return errorCollection;
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.setIsRequired(config.getBoolean("notification.xmpp.enabled", false));
        if (this.isRequired()) {
            this.setGroupsToNotify(config.getList("notification.xmpp.groupsToNotify"));
            this.setRecipients(config.getString("notification.xmpp.recipients"));
        } else {
            this.setGroupsToNotify(Collections.emptyList());
            this.setRecipients(null);
        }
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        BambooHierarchicalConfiguration configuration = new BambooHierarchicalConfiguration();
        configuration.setProperty("notification.xmpp.groupsToNotify", (Object)this.getGroupsToNotify());
        configuration.setProperty("notification.xmpp.enabled", (Object)this.isRequired());
        configuration.setDelimiterParsingDisabled(true);
        configuration.setProperty("notification.xmpp.recipients", (Object)this.getRecipients());
        return configuration;
    }

    public List getGroupsToNotify() {
        return this.groupsToNotify;
    }

    public void setGroupsToNotify(List groupsToNotify) {
        if (groupsToNotify != null) {
            this.groupsToNotify = new ArrayList(groupsToNotify);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 17).append(this.isRequired()).append((Object)this.getGroupsToNotify()).append((Object)this.getRecipients()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SmackXmppMessageSender)) {
            return false;
        }
        SmackXmppMessageSender rhs = (SmackXmppMessageSender)o;
        return new EqualsBuilder().append(this.isRequired(), rhs.isRequired()).append((Object)this.getGroupsToNotify(), (Object)rhs.getGroupsToNotify()).append((Object)this.getRecipients(), (Object)rhs.getRecipients()).isEquals();
    }

    public int compareTo(Object obj) {
        SmackXmppMessageSender o = (SmackXmppMessageSender)obj;
        return new CompareToBuilder().append(this.isRequired(), o.isRequired()).append((Object)this.getGroupsToNotify(), (Object)o.getGroupsToNotify()).append((Object)this.getRecipients(), (Object)o.getRecipients()).toComparison();
    }
}

