/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp.commands;

import com.atlassian.bamboo.comment.CommentService;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.xmpp.commands.AbstractSmackCommand;
import com.atlassian.user.User;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AddComment
extends AbstractSmackCommand {
    private static final Logger log = Logger.getLogger(AddComment.class);
    private ResultsSummaryManager resultsSummaryManager;
    private CommentService commentService;
    private PlanManager planManager;

    @Override
    public String run(Map<String, String> context, BambooUser user) {
        this.init(context);
        if (this.getProjectKey() == null || this.getBuildKey() == null || this.getBuildNumber() == null) {
            this.setResponseMessage("Unknown build result. Please specify valid build result to comment. Usage:\ncomment <build key> <comment>");
            return "ERROR";
        }
        if (StringUtils.isBlank((CharSequence)this.getCommandBody())) {
            this.setResponseMessage("You cannot enter a blank comment.");
            return "ERROR";
        }
        PlanKey planKey = this.getPlanResultKey().getPlanKey();
        Plan build = this.planManager.getPlanByKey(planKey);
        if (build == null) {
            this.setResponseMessage(this.getPlanResultKey() + " does not exist.");
            return "ERROR";
        }
        ResultsSummary summary = this.resultsSummaryManager.getResultsSummary(this.getPlanResultKey());
        if (summary == null) {
            this.setResponseMessage(this.getPlanResultKey() + " does not exist.");
            return "ERROR";
        }
        this.commentService.addComment(this.commandBody, (User)user, (BambooIdProvider)summary);
        this.setResponseMessage(this.getPlanResultKey() + " commented.");
        return "SUCCESS";
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

