/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp.commands;

import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.labels.LabelParser;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.xmpp.commands.AbstractSmackCommand;
import com.atlassian.user.User;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AddLabel
extends AbstractSmackCommand {
    private static final Logger log = Logger.getLogger(AddLabel.class);
    ResultsSummaryManager resultsSummaryManager;
    LabelManager labelManager;
    PlanManager planManager;

    @Override
    public String run(Map<String, String> context, BambooUser user) {
        this.init(context);
        if (this.getProjectKey() == null || this.getBuildKey() == null || this.getBuildNumber() == null) {
            this.setResponseMessage("Unknown build result. Please specify valid build result to label. Usage:\nlabel <build key> <new-label>");
            return "ERROR";
        }
        if (StringUtils.isBlank((CharSequence)this.getCommandBody())) {
            this.setResponseMessage("You cannot enter blank labels.");
            return "ERROR";
        }
        List<String> labels = LabelParser.split(this.getCommandBody());
        for (String label : labels) {
            boolean validLabel = LabelParser.isValidLabelName(label);
            if (validLabel) continue;
            this.setResponseMessage(label + " contains invalid character " + LabelParser.getFirstInvalidLabelCharacter(label));
            return "ERROR";
        }
        PlanKey resultKey = this.getPlanResultKey().getPlanKey();
        Plan build = this.planManager.getPlanByKey(resultKey);
        if (build == null) {
            this.setResponseMessage(resultKey + " does not exist.");
            return "ERROR";
        }
        ResultsSummary summary = this.resultsSummaryManager.getResultsSummary(this.getPlanResultKey());
        if (summary == null) {
            this.setResponseMessage(resultKey + " does not exist.");
            return "ERROR";
        }
        for (String label : labels) {
            this.labelManager.addLabel(label, this.getPlanResultKey(), (User)user);
        }
        this.setResponseMessage(resultKey + " labelled '" + this.getCommandBody() + "'");
        return "SUCCESS";
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }
}

