/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp.commands;

import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.InitialBuildTriggerReason;
import com.atlassian.bamboo.xmpp.commands.SimpleSmackCommand;
import com.google.common.collect.ImmutableList;
import org.apache.log4j.Logger;

public class CommitCommentSmackCommand
extends SimpleSmackCommand {
    private static final Logger log = Logger.getLogger(CommitCommentSmackCommand.class);

    @Override
    public ErrorCollection validate() {
        if (this.getProjectKey() == null || this.getBuildKey() == null || this.getBuildNumber() == null) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage("Unknown build result. Please specify valid build result to retrieve commit information for. Usage:\nchanges <build key> ");
            return errorCollection;
        }
        return null;
    }

    @Override
    public String execute() {
        ResultsSummary summary = this.getResultsSummary();
        if (summary != null) {
            ImmutableList commits = summary.getCommits();
            StringBuilder sb = new StringBuilder("Returning all commit comments for " + this.getPlanResultKey() + "...\n\n");
            if (!commits.isEmpty()) {
                for (Commit commit : commits) {
                    String name = commit.getAuthor().getFullName();
                    String comment = commit.getComment();
                    sb.append("Change by ").append(name).append(":\n").append(comment).append("\n\n");
                }
            } else {
                TriggerReason triggerReason = summary.getTriggerReason();
                if (triggerReason instanceof InitialBuildTriggerReason) {
                    sb.append("This is the initial clean build.\n");
                }
                sb.append("No commits exist for this build.\n\n");
            }
            sb.append(this.getServerBaseUrl()).append("/browse/").append(this.getPlanResultKey()).append("/commit");
            this.setResponseMessage(sb.toString());
            return "SUCCESS";
        }
        this.setResponseMessage("No build results summary found");
        return "ERROR";
    }
}

