/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.xmpp.commands;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.xmpp.commands.AbstractSmackCommand;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleSmackCommand
extends AbstractSmackCommand {
    private static final Logger log = Logger.getLogger(SimpleSmackCommand.class);
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private ResultsSummaryManager resultsSummaryManager;

    public String run(Map context, BambooUser user) {
        this.init(context);
        ErrorCollection errorCollection = this.validate();
        if (errorCollection != null && errorCollection.hasAnyErrors()) {
            StringBuilder errorMessages = new StringBuilder();
            for (String error : errorCollection.getErrorMessages()) {
                errorMessages.append(error).append("\n");
            }
            this.setResponseMessage(errorMessages.toString());
            return "ERROR";
        }
        return this.execute();
    }

    public abstract ErrorCollection validate();

    public abstract String execute();

    @Nullable
    protected ResultsSummary getResultsSummary() {
        return this.resultsSummaryManager.getResultsSummary(this.getPlanResultKey());
    }

    protected String getServerBaseUrl() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

