#!/bin/sh

DELIMITER=123_MOUNTPOINT_321

homeMountsInContainer=/tmp/homemountpoints
if [ ! -d ${homeMountsInContainer} ] ; then
	exit
fi

for mountPoint in $(find ${homeMountsInContainer} -type d -name ${DELIMITER} -prune) ; do
	relativePath=$(echo $mountPoint | sed -e s@^${homeMountsInContainer}/@@ -e s@/${DELIMITER}@@)
	echo Processing $relativePath ...
	target=~/${relativePath}

	if mountpoint -q "${target}" ; then
		rm -rf ${target} 2>/dev/null
	    echo Rewiring contents of ${mountPoint} to mount point ${target}
	    for entry in $(ls -A ${mountPoint}) ; do
	        ln -s "${mountPoint}/${entry}" ${target}
	    done
	else
		echo Rewiring ${mountPoint} to ${target}
		rm -rf ${target}
	    mkdir -p $(dirname ${target})
	    ln -s "${mountPoint}" "${target}"
	fi
done

rm $0
