/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.credentials;

import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.project.Project;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SharedCredentials<B extends SharedCredentials<B, C>, C extends SharedCredentialsProperties>
extends RootEntityPropertiesBuilder<C> {
    public static final String TYPE = "shared credentials";
    protected String name;
    protected BambooOidProperties oid;
    protected ProjectProperties project;

    protected SharedCredentials() {
    }

    protected SharedCredentials(@NotNull String name) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
    }

    public B name(@NotNull String name) {
        ImporterUtils.checkNotBlank("name", name);
        this.name = name;
        return (B)this;
    }

    public B oid(@Nullable String oid) throws PropertiesValidationException {
        return this.oid(oid != null ? new BambooOid(oid) : null);
    }

    public B oid(@Nullable BambooOid oid) throws PropertiesValidationException {
        this.oid = oid != null ? (BambooOidProperties)EntityPropertiesBuilders.build(oid) : null;
        return (B)this;
    }

    public B project(@NotNull Project project) {
        ImporterUtils.checkNotNull("project", project);
        this.project = (ProjectProperties)EntityPropertiesBuilders.build(project);
        return (B)this;
    }

    @Override
    public String humanReadableType() {
        return TYPE;
    }

    @Override
    public String humanReadableId() {
        return String.format("%s %s", TYPE, StringUtils.defaultString((String)this.name, (String)"<unknown>"));
    }

    @Override
    protected abstract C build();
}

