/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.deployment;

import com.atlassian.bamboo.specs.api.builders.deployment.Environment;
import com.atlassian.bamboo.specs.api.builders.docker.DockerConfiguration;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.specs.api.model.deployment.configuration.EnvironmentPluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.docker.DockerConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.VariableValidator;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConstructFrom(value={"name"})
public class EnvironmentProperties
implements EntityProperties {
    private String name;
    private String description;
    private List<TaskProperties> tasks;
    private List<TaskProperties> finalTasks;
    private List<TriggerProperties> triggers;
    private List<VariableProperties> variables;
    private List<RequirementProperties> requirements;
    private List<NotificationProperties> notifications;
    private DockerConfigurationProperties dockerConfiguration;
    private List<EnvironmentPluginConfigurationProperties> pluginConfigurations;
    private Environment.ReleaseApprovalPrerequisite releaseApprovalPrerequisite;

    private EnvironmentProperties() {
        this.tasks = Collections.emptyList();
        this.finalTasks = Collections.emptyList();
        this.triggers = Collections.emptyList();
        this.variables = Collections.emptyList();
        this.requirements = Collections.emptyList();
        this.notifications = Collections.emptyList();
        this.dockerConfiguration = (DockerConfigurationProperties)EntityPropertiesBuilders.build(new DockerConfiguration().enabled(false));
        this.pluginConfigurations = Collections.emptyList();
        this.releaseApprovalPrerequisite = Environment.ReleaseApprovalPrerequisite.getDefault();
    }

    public EnvironmentProperties(@NotNull String name, @Nullable String description, @NotNull List<TaskProperties> tasks, @NotNull List<TaskProperties> finalTasks, @NotNull List<TriggerProperties> triggers, @NotNull List<VariableProperties> variables, @NotNull List<RequirementProperties> requirements, @NotNull List<NotificationProperties> notifications, @NotNull DockerConfigurationProperties dockerConfiguration, @NotNull Collection<EnvironmentPluginConfigurationProperties> pluginConfigurations, @NotNull Environment.ReleaseApprovalPrerequisite releaseApprovalPrerequisite) {
        this.name = name;
        this.description = description;
        this.tasks = Collections.unmodifiableList(new ArrayList<TaskProperties>(tasks));
        this.finalTasks = Collections.unmodifiableList(new ArrayList<TaskProperties>(finalTasks));
        this.triggers = Collections.unmodifiableList(new ArrayList<TriggerProperties>(triggers));
        this.variables = Collections.unmodifiableList(new ArrayList<VariableProperties>(variables));
        this.requirements = Collections.unmodifiableList(new ArrayList<RequirementProperties>(requirements));
        this.notifications = Collections.unmodifiableList(new ArrayList<NotificationProperties>(notifications));
        this.dockerConfiguration = dockerConfiguration;
        this.pluginConfigurations = Collections.unmodifiableList(new ArrayList<EnvironmentPluginConfigurationProperties>(pluginConfigurations));
        this.releaseApprovalPrerequisite = releaseApprovalPrerequisite;
        this.validate();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TaskProperties> getTasks() {
        return this.tasks;
    }

    public List<TaskProperties> getFinalTasks() {
        return this.finalTasks;
    }

    public List<TriggerProperties> getTriggers() {
        return this.triggers;
    }

    public List<VariableProperties> getVariables() {
        return this.variables;
    }

    public List<RequirementProperties> getRequirements() {
        return this.requirements;
    }

    public List<NotificationProperties> getNotifications() {
        return this.notifications;
    }

    public DockerConfigurationProperties getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    public List<EnvironmentPluginConfigurationProperties> getPluginConfigurations() {
        return this.pluginConfigurations;
    }

    public Environment.ReleaseApprovalPrerequisite getReleaseApprovalPrerequisite() {
        return this.releaseApprovalPrerequisite;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentProperties that = (EnvironmentProperties)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getTasks(), that.getTasks()) && Objects.equals(this.getFinalTasks(), that.getFinalTasks()) && Objects.equals(this.getTriggers(), that.getTriggers()) && Objects.equals(this.getVariables(), that.getVariables()) && Objects.equals(this.getRequirements(), that.getRequirements()) && Objects.equals(this.getNotifications(), that.getNotifications()) && Objects.equals(this.getDockerConfiguration(), that.getDockerConfiguration()) && Objects.equals(this.getPluginConfigurations(), that.getPluginConfigurations()) && Objects.equals((Object)this.getReleaseApprovalPrerequisite(), (Object)that.getReleaseApprovalPrerequisite());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getDescription(), this.getTasks(), this.getFinalTasks(), this.getTriggers(), this.getVariables(), this.getRequirements(), this.getNotifications(), this.getDockerConfiguration(), this.getPluginConfigurations(), this.getReleaseApprovalPrerequisite()});
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Environment");
        ValidationUtils.validateName(context, this.name);
        ImporterUtils.checkNotNull(context.with("Docker configuration"), "docker configuration", this.dockerConfiguration);
        ImporterUtils.checkNoErrors(VariableValidator.validateUniqueVariableNames(this.variables));
    }
}

