/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.branches;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanBranchIdentifierProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class BranchIntegrationProperties
implements EntityProperties {
    private boolean enabled = true;
    private PlanBranchIdentifierProperties integrationBranch;
    private boolean gatekeeper;
    private boolean pushOn;

    private BranchIntegrationProperties() {
    }

    public BranchIntegrationProperties(boolean enabled, @Nullable PlanBranchIdentifierProperties integrationBranch, boolean gatekeeper, boolean pushOn) throws PropertiesValidationException {
        this.enabled = enabled;
        this.integrationBranch = integrationBranch;
        this.gatekeeper = gatekeeper;
        this.pushOn = pushOn;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BranchIntegrationProperties that = (BranchIntegrationProperties)o;
        return this.isEnabled() == that.isEnabled() && this.isGatekeeper() == that.isGatekeeper() && this.isPushOn() == that.isPushOn() && Objects.equals(this.getIntegrationBranch(), that.getIntegrationBranch());
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled(), this.getIntegrationBranch(), this.isGatekeeper(), this.isPushOn());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public PlanBranchIdentifierProperties getIntegrationBranch() {
        return this.integrationBranch;
    }

    public boolean isGatekeeper() {
        return this.gatekeeper;
    }

    public boolean isPushOn() {
        return this.pushOn;
    }

    @Override
    public void validate() {
    }
}

