/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators;

import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class BambooOidValidator {
    private BambooOidValidator() {
    }

    public static List<ValidationProblem> validate(@NotNull BambooOidProperties oidProperties) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        String oid = oidProperties.getOid();
        if (!StringUtils.containsOnly((CharSequence)oid, (String)"0123456789abcdefghijklmnopqrstuvwxyz")) {
            errors.add(new ValidationProblem("OID must be string containing only numbers and lowercase letters [0-9a-z]."));
        }
        try {
            Long l = Long.valueOf(oid, 36);
        }
        catch (NumberFormatException e) {
            errors.add(new ValidationProblem("Invalid OID value."));
        }
        return errors;
    }
}

