/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.requirement;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;

public class Requirement
extends EntityPropertiesBuilder<RequirementProperties> {
    private String key;
    private String matchValue = ".*";
    private MatchType matchType = MatchType.EXISTS;

    public Requirement(String key) {
        this.key = key;
    }

    public static Requirement exists(String key) {
        return new Requirement(key).matchType(MatchType.EXISTS);
    }

    public static Requirement equals(String key, String value) {
        return new Requirement(key).matchType(MatchType.EQUALS).matchValue(value);
    }

    public static Requirement matches(String key, String regexp) {
        return new Requirement(key).matchType(MatchType.MATCHES).matchValue(regexp);
    }

    public Requirement matchValue(String value) {
        this.matchValue = value;
        return this;
    }

    public Requirement matchType(MatchType matchType) {
        this.matchType = matchType;
        return this;
    }

    @Override
    protected RequirementProperties build() {
        return new RequirementProperties(this.key, this.matchValue, this.matchType);
    }

    public static enum MatchType {
        EXISTS,
        EQUALS,
        MATCHES;

    }
}

