/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.permission;

import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.permission.PermissionValidator;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@ConstructFrom(value={"planIdentifier"})
@Immutable
public class PlanPermissionsProperties
implements EntityProperties {
    private final PlanIdentifierProperties planIdentifier;
    private final PermissionsProperties permissions;

    private PlanPermissionsProperties() {
        this.planIdentifier = null;
        this.permissions = null;
    }

    public PlanPermissionsProperties(@NotNull PlanIdentifier planIdentifier, @NotNull Permissions permissions) throws PropertiesValidationException {
        this.planIdentifier = (PlanIdentifierProperties)EntityPropertiesBuilders.build(planIdentifier);
        this.permissions = (PermissionsProperties)EntityPropertiesBuilders.build(permissions);
        this.validate();
    }

    @Override
    public void validate() throws PropertiesValidationException {
        ImporterUtils.checkNotNull("planIdentifier", this.planIdentifier);
        ImporterUtils.checkNotNull("permissions", this.permissions);
        ImporterUtils.checkNoErrors(PermissionValidator.validatePermissions(this.permissions, PermissionValidator.PermissionTarget.PLAN));
    }

    public PlanIdentifierProperties getPlanIdentifier() {
        return this.planIdentifier;
    }

    public PermissionsProperties getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanPermissionsProperties that = (PlanPermissionsProperties)o;
        return Objects.equals(this.getPlanIdentifier(), that.getPlanIdentifier()) && Objects.equals(this.getPermissions(), that.getPermissions());
    }

    public int hashCode() {
        return Objects.hash(this.getPlanIdentifier(), this.getPermissions());
    }
}

