/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan;

import com.atlassian.bamboo.specs.api.builders.docker.DockerConfiguration;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.docker.DockerConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.AbstractPlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactSubscriptionProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.plan.JobValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@ConstructFrom(value={"name", "key"})
@Immutable
public final class JobProperties
extends AbstractPlanProperties {
    private final List<ArtifactProperties> artifacts;
    private final List<TaskProperties> tasks;
    private final List<TaskProperties> finalTasks;
    private final List<RequirementProperties> requirements;
    private final List<ArtifactSubscriptionProperties> artifactSubscriptions;
    private final boolean cleanWorkingDirectory;
    private final DockerConfigurationProperties dockerConfiguration;

    private JobProperties() {
        this.tasks = Collections.emptyList();
        this.finalTasks = Collections.emptyList();
        this.artifacts = Collections.emptyList();
        this.requirements = Collections.emptyList();
        this.artifactSubscriptions = Collections.emptyList();
        this.cleanWorkingDirectory = false;
        this.dockerConfiguration = (DockerConfigurationProperties)EntityPropertiesBuilders.build(new DockerConfiguration().enabled(false));
    }

    public JobProperties(BambooKeyProperties key, String name, String description, boolean enabled, boolean cleanWorkingDirectory, Collection<PluginConfigurationProperties> pluginConfigurations, @NotNull List<ArtifactProperties> artifacts, @NotNull List<TaskProperties> tasks, @NotNull List<TaskProperties> finalTasks, @NotNull List<RequirementProperties> requirements, @NotNull List<ArtifactSubscriptionProperties> artifactSubscriptions, @NotNull DockerConfigurationProperties dockerConfiguration) throws PropertiesValidationException {
        super(null, key, name, description, enabled, pluginConfigurations);
        this.cleanWorkingDirectory = cleanWorkingDirectory;
        this.artifacts = Collections.unmodifiableList(new ArrayList<ArtifactProperties>(artifacts));
        this.tasks = Collections.unmodifiableList(new ArrayList<TaskProperties>(tasks));
        this.finalTasks = Collections.unmodifiableList(new ArrayList<TaskProperties>(finalTasks));
        this.requirements = Collections.unmodifiableList(new ArrayList<RequirementProperties>(requirements));
        this.artifactSubscriptions = Collections.unmodifiableList(new ArrayList<ArtifactSubscriptionProperties>(artifactSubscriptions));
        this.dockerConfiguration = dockerConfiguration;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobProperties that = (JobProperties)o;
        return Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && this.isEnabled() == that.isEnabled() && this.isCleanWorkingDirectory() == that.isCleanWorkingDirectory() && Objects.equals(this.getPluginConfigurations(), that.getPluginConfigurations()) && Objects.equals(this.getArtifacts(), that.getArtifacts()) && Objects.equals(this.getTasks(), that.getTasks()) && Objects.equals(this.getFinalTasks(), that.getFinalTasks()) && Objects.equals(this.getRequirements(), that.getRequirements()) && Objects.equals(this.getArtifactSubscriptions(), that.getArtifactSubscriptions()) && Objects.equals(this.getDockerConfiguration(), that.getDockerConfiguration());
    }

    public int hashCode() {
        return Objects.hash(this.getOid(), this.getKey(), this.getName(), this.getDescription(), this.isEnabled(), this.isCleanWorkingDirectory(), this.getPluginConfigurations(), this.getArtifacts(), this.getTasks(), this.getFinalTasks(), this.getRequirements(), this.getArtifactSubscriptions(), this.getDockerConfiguration());
    }

    public boolean isCleanWorkingDirectory() {
        return this.cleanWorkingDirectory;
    }

    public List<ArtifactProperties> getArtifacts() {
        return this.artifacts;
    }

    public List<TaskProperties> getTasks() {
        return this.tasks;
    }

    public List<TaskProperties> getFinalTasks() {
        return this.finalTasks;
    }

    public List<RequirementProperties> getRequirements() {
        return this.requirements;
    }

    @NotNull
    public List<ArtifactSubscriptionProperties> getArtifactSubscriptions() {
        return this.artifactSubscriptions;
    }

    public DockerConfigurationProperties getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of("Job");
        ImporterUtils.checkRequired(context.with("artifacts"), this.artifacts);
        ImporterUtils.checkRequired(context.with("tasks"), this.tasks);
        ImporterUtils.checkRequired(context.with("final tasks"), this.finalTasks);
        ImporterUtils.checkRequired(context.with("Docker configuration"), this.dockerConfiguration);
        ImporterUtils.checkNoErrors(JobValidator.validate(this));
    }
}

