/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.branches;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGeneratorName;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.plan.branch.BranchCleanupValidator;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.plan.branches.BranchCleanupEmitter")
@Immutable
public class BranchCleanupProperties
implements EntityProperties {
    private boolean removeDeletedFromRepository = true;
    private boolean removeInactiveInRepository = true;
    private Duration removeDeletedFromRepositoryPeriod = Duration.ZERO;
    private Duration removeInactiveInRepositoryPeriod = Duration.ZERO;

    private BranchCleanupProperties() {
    }

    public BranchCleanupProperties(boolean removeDeletedFromRepository, @NotNull Duration removeDeletedFromRepositoryPeriod, boolean removeInactiveInRepository, @NotNull Duration removeInactiveInRepositoryPeriod) throws PropertiesValidationException {
        this.removeDeletedFromRepository = removeDeletedFromRepository;
        this.removeDeletedFromRepositoryPeriod = removeDeletedFromRepositoryPeriod;
        this.removeInactiveInRepository = removeInactiveInRepository;
        this.removeInactiveInRepositoryPeriod = removeInactiveInRepositoryPeriod;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BranchCleanupProperties that = (BranchCleanupProperties)o;
        return this.isRemoveDeletedFromRepository() == that.isRemoveDeletedFromRepository() && this.isRemoveInactiveInRepository() == that.isRemoveInactiveInRepository() && Objects.equals(this.getRemoveInactiveInRepositoryPeriod(), that.getRemoveInactiveInRepositoryPeriod()) && Objects.equals(this.getRemoveDeletedFromRepositoryPeriod(), that.getRemoveDeletedFromRepositoryPeriod());
    }

    public int hashCode() {
        return Objects.hash(this.isRemoveDeletedFromRepository(), this.isRemoveInactiveInRepository(), this.getRemoveDeletedFromRepositoryPeriod(), this.getRemoveInactiveInRepositoryPeriod());
    }

    public boolean isRemoveDeletedFromRepository() {
        return this.removeDeletedFromRepository;
    }

    public boolean isRemoveInactiveInRepository() {
        return this.removeInactiveInRepository;
    }

    public Duration getRemoveDeletedFromRepositoryPeriod() {
        return this.removeDeletedFromRepositoryPeriod;
    }

    public Duration getRemoveInactiveInRepositoryPeriod() {
        return this.removeInactiveInRepositoryPeriod;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNoErrors(BranchCleanupValidator.validate(this));
    }
}

