/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.project;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.project.ProjectValidator;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class ProjectProperties
implements EntityProperties {
    private BambooOidProperties oid;
    private BambooKeyProperties key;
    private String name;
    private String description;

    private ProjectProperties() {
    }

    public ProjectProperties(BambooOidProperties oid, BambooKeyProperties key, String name, String description) throws PropertiesValidationException {
        this.oid = oid;
        this.key = key;
        this.name = name;
        this.description = description;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectProperties that = (ProjectProperties)o;
        return Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription());
    }

    public int hashCode() {
        return Objects.hash(this.getOid(), this.getKey(), this.getName(), this.getDescription());
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    @Nullable
    public BambooKeyProperties getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNoErrors(ProjectValidator.validate(this));
    }
}

