/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.common;

import com.atlassian.bamboo.specs.api.validators.common.BambooStringUtils;
import com.atlassian.bamboo.specs.api.validators.common.DbConstraintUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static boolean containsBambooVariable(@Nullable String value) {
        return value != null && value.contains("${bamboo");
    }

    public static boolean repositoryUriContainsPassword(URI repositoryUri) {
        return StringUtils.contains((CharSequence)repositoryUri.getRawUserInfo(), (CharSequence)":");
    }

    public static Optional<ValidationProblem> validateRequired(@NotNull ValidationContext validationContext, @Nullable Object value) {
        if (value == null) {
            return Optional.of(new ValidationProblem(validationContext, "must be defined"));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validateRequiredString(@NotNull ValidationContext validationContext, @Nullable String value) {
        return ValidationUtils.validateRequiredString(validationContext, value, false);
    }

    public static Optional<ValidationProblem> validateRequiredString(@NotNull ValidationContext validationContext, @Nullable String value, boolean requireNonBlank) {
        if (value == null) {
            return Optional.of(new ValidationProblem(validationContext, "must be defined"));
        }
        if (requireNonBlank ? StringUtils.isBlank((CharSequence)value) : StringUtils.isEmpty((CharSequence)value)) {
            return Optional.of(new ValidationProblem(validationContext, "can not be empty"));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validateBoolean(@NotNull ValidationContext validationContext, @Nullable String value) {
        if (value != null && BooleanUtils.toBooleanObject((String)value) == null) {
            return Optional.of(new ValidationProblem(validationContext, "must be boolean value but is '%s'", value));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validateRequiredBoolean(@NotNull ValidationContext validationContext, @Nullable String value) {
        if (value == null) {
            return Optional.of(new ValidationProblem(validationContext, "must be defined"));
        }
        return ValidationUtils.validateBoolean(validationContext, value);
    }

    public static Optional<ValidationProblem> validateLong(@NotNull ValidationContext validationContext, @Nullable String value) {
        if (value == null) {
            return Optional.empty();
        }
        if (!NumberUtils.isNumber((String)value)) {
            return Optional.of(new ValidationProblem(validationContext, "must be numerical long value but is '%s'", value));
        }
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return Optional.of(new ValidationProblem(validationContext, "must be numerical long value but is '%s'", value));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validateRequiredLong(@NotNull ValidationContext validationContext, @Nullable String value) {
        if (value == null) {
            return Optional.of(new ValidationProblem(validationContext, "must be defined"));
        }
        return ValidationUtils.validateLong(validationContext, value);
    }

    public static <E extends Enum<E>> Optional<ValidationProblem> validateEnum(@NotNull ValidationContext validationContext, @Nullable String value, @NotNull Class<E> enumClass) {
        if (value == null) {
            return Optional.empty();
        }
        if (!EnumUtils.isValidEnum(enumClass, (String)value)) {
            return Optional.of(new ValidationProblem(validationContext, "must be enum value of %s but is '%s'", ArrayUtils.toString(enumClass.getEnumConstants(), (String)"{}"), value));
        }
        return Optional.empty();
    }

    public static <E extends Enum<E>> Optional<ValidationProblem> validateRequiredEnum(@NotNull ValidationContext validationContext, @Nullable String value, @NotNull Class<E> enumClass) {
        if (value == null) {
            return Optional.of(new ValidationProblem(validationContext, "must be defined"));
        }
        return ValidationUtils.validateEnum(validationContext, value, enumClass);
    }

    public static Optional<ValidationProblem> validatePositive(@NotNull ValidationContext validationContext, long value) {
        if (value < 0L) {
            return Optional.of(new ValidationProblem(validationContext, "must be >= 0 but is %d", value));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validatePositive(@NotNull ValidationContext validationContext, int value) {
        if (value < 0) {
            return Optional.of(new ValidationProblem(validationContext, "must be >= 0 but is %d", value));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validateUrl(@NotNull ValidationContext validationContext, @Nullable String urlString, @NotNull Set<String> supportedSchemes) {
        if (urlString == null) {
            return Optional.empty();
        }
        try {
            URI uri = new URI(urlString);
            String scheme = uri.getScheme();
            if (!supportedSchemes.contains(uri.getScheme())) {
                return Optional.of(new ValidationProblem(validationContext, "scheme '%s' is not supported - supported schemes are: %s", scheme, String.join((CharSequence)", ", supportedSchemes)));
            }
        }
        catch (URISyntaxException e) {
            if (urlString.startsWith("\\\\") || !urlString.contains("://")) {
                return Optional.empty();
            }
            return Optional.of(new ValidationProblem(validationContext, String.format("Malformed URL: %s", urlString)));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validateNotContainsXssRelatedCharacters(@NotNull ValidationContext validationContext, @Nullable String value) {
        if (BambooStringUtils.containsXssRelatedCharacters(value)) {
            return Optional.of(new ValidationProblem(validationContext, "can not contain any of those characters: %s but it is '%s'", Arrays.toString(BambooStringUtils.XSS_RELATED_CHARACTERS), value));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validateNotContainsRelaxedXssRelatedCharacters(@NotNull ValidationContext validationContext, @Nullable String value) {
        if (BambooStringUtils.containsRelaxedXssRelatedCharacters(value)) {
            return Optional.of(new ValidationProblem(validationContext, "can not contain any of those characters: %s but it is '%s'", Arrays.toString(BambooStringUtils.RELAXED_XSS_RELATED_CHARACTERS), value));
        }
        return Optional.empty();
    }

    public static Optional<ValidationProblem> validateNotContainsShellInjectionRelatedCharacters(@NotNull ValidationContext validationContext, @Nullable String value) {
        if (BambooStringUtils.containsShellInjectionRelatedCharacters(value)) {
            return Optional.of(new ValidationProblem(validationContext, "can not contain any of those characters: %s, nor this substring: '%s' but it is '%s'", Arrays.toString(BambooStringUtils.SHELL_INJECTION_RELATED_CHARACTERS), "$(", value));
        }
        return Optional.empty();
    }

    @NotNull
    public static List<ValidationProblem> validateName(@NotNull ValidationContext validationContext, @Nullable String name) {
        return ValidationUtils.validateName(validationContext, name, true);
    }

    @NotNull
    public static List<ValidationProblem> validateName(@NotNull ValidationContext validationContext, @Nullable String name, boolean required) {
        ValidationContext validationContextWithName = validationContext.with("Name");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (required) {
            ValidationUtils.validateRequiredString(validationContextWithName, name, true).ifPresent(errors::add);
        }
        DbConstraintUtils.checkLength(validationContextWithName, name, 255, "it can not be longer than 255 characters but has " + StringUtils.length((CharSequence)name)).ifPresent(errors::add);
        ValidationUtils.validateNotContainsXssRelatedCharacters(validationContextWithName, name).ifPresent(errors::add);
        return errors;
    }

    @NotNull
    public static List<ValidationProblem> validateDescription(@NotNull ValidationContext validationContext, @Nullable String description) {
        ValidationContext validationContextWithDescription = validationContext.with("Description");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        ValidationUtils.validateNotContainsXssRelatedCharacters(validationContextWithDescription, description).ifPresent(errors::add);
        return errors;
    }
}

