/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.repository;

import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class VcsRepositoryValidator {
    private VcsRepositoryValidator() {
    }

    public static List<ValidationProblem> validate(@NotNull VcsRepositoryProperties vcsRepositoryProperties) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        String parentName = vcsRepositoryProperties.getParentName();
        ValidationContext context = ValidationContext.of("VCS repository");
        if (!vcsRepositoryProperties.hasParent()) {
            if (parentName != null) {
                errors.add(new ValidationProblem(context, "Global repository cannot have parent"));
            }
            errors.addAll(ValidationUtils.validateName(context, vcsRepositoryProperties.getName()));
            errors.addAll(ValidationUtils.validateDescription(context, vcsRepositoryProperties.getDescription()));
            ValidationUtils.validateRequired(context.with("Atlassian plugin"), vcsRepositoryProperties.getAtlassianPlugin()).ifPresent(errors::add);
        } else if (parentName != null) {
            if (vcsRepositoryProperties.getName() != null) {
                errors.add(new ValidationProblem(context, "Cannot set name when inheriting data from another repository definition and you have '%s'", vcsRepositoryProperties.getName()));
            }
            if (vcsRepositoryProperties.getDescription() != null) {
                errors.add(new ValidationProblem(context, "Cannot set description when inheriting data from another repository definition and you have '%'", vcsRepositoryProperties.getDescription()));
            }
        } else {
            errors.addAll(ValidationUtils.validateName(context, vcsRepositoryProperties.getName()));
            errors.addAll(ValidationUtils.validateDescription(context, vcsRepositoryProperties.getDescription()));
        }
        return errors;
    }
}

