/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.ecs.remote;

import com.atlassian.bamboo.Key;
import com.atlassian.buildeng.ecs.remote.GlobalConfiguration;
import com.atlassian.buildeng.ecs.remote.RemoteWatchdogJob;
import com.atlassian.buildeng.spi.isolated.docker.Configuration;
import com.atlassian.buildeng.spi.isolated.docker.ConfigurationPersistence;
import com.atlassian.buildeng.spi.isolated.docker.HostFolderMapping;
import com.atlassian.buildeng.spi.isolated.docker.HostFolderMappingModuleDescriptor;
import com.atlassian.buildeng.spi.isolated.docker.IsolatedAgentService;
import com.atlassian.buildeng.spi.isolated.docker.IsolatedDockerAgentException;
import com.atlassian.buildeng.spi.isolated.docker.IsolatedDockerAgentRequest;
import com.atlassian.buildeng.spi.isolated.docker.IsolatedDockerAgentResult;
import com.atlassian.buildeng.spi.isolated.docker.IsolatedDockerRequestCallback;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import org.apache.http.client.utils.URIBuilder;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECSIsolatedAgentServiceImpl
implements IsolatedAgentService,
LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(ECSIsolatedAgentServiceImpl.class);
    static String PLUGIN_JOB_KEY = "ecs-remote-watchdog";
    static long PLUGIN_JOB_INTERVAL_MILLIS = 60000L;
    static final String RESULT_PREFIX = "result.isolated.docker.";
    static final String RESULT_PART_TASKARN = "TaskARN";
    static final String AGENT_CONTAINER_NAME = "bamboo-agent";
    private final GlobalConfiguration globalConfiguration;
    private final PluginScheduler pluginScheduler;
    private final PluginAccessor pluginAccessor;

    public ECSIsolatedAgentServiceImpl(GlobalConfiguration globalConfiguration, PluginScheduler pluginScheduler, PluginAccessor pluginAccessor) {
        this.globalConfiguration = globalConfiguration;
        this.pluginScheduler = pluginScheduler;
        this.pluginAccessor = pluginAccessor;
    }

    public void startAgent(IsolatedDockerAgentRequest request, IsolatedDockerRequestCallback callback) {
        Client client = ECSIsolatedAgentServiceImpl.createClient();
        WebResource resource = client.resource(this.globalConfiguration.getCurrentServer() + "/rest/scheduler");
        try {
            IsolatedDockerAgentResult result = (IsolatedDockerAgentResult)((WebResource.Builder)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).post(IsolatedDockerAgentResult.class, (Object)this.createBody(request, this.globalConfiguration));
            logger.info("result:" + result.isRetryRecoverable() + " " + result.getErrors() + " " + result.getCustomResultData());
            callback.handle(result);
        }
        catch (UniformInterfaceException e) {
            int code = e.getResponse().getClientResponseStatus().getStatusCode();
            String s = "";
            if (e.getResponse().hasEntity()) {
                s = (String)e.getResponse().getEntity(String.class);
            }
            logger.error("Error contacting ECS:" + code + " " + s, (Throwable)e);
            if (code == 504 || code == 503) {
                callback.handle(new IsolatedDockerAgentResult().withRetryRecoverable(s));
            } else {
                callback.handle(new IsolatedDockerAgentException((Throwable)e));
            }
        }
        catch (ClientHandlerException che) {
            logger.error("Error connecting to ECS:", (Throwable)che);
            callback.handle(new IsolatedDockerAgentResult().withRetryRecoverable(che.getMessage()));
        }
        catch (Exception t) {
            logger.error("unknown error", (Throwable)t);
            callback.handle(new IsolatedDockerAgentException((Throwable)t));
        }
    }

    static Client createClient() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJsonProvider.class);
        clientConfig.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        clientConfig.getProperties().put("com.sun.jersey.api.json.POJOMappingFeature", true);
        Client client = Client.create((ClientConfig)clientConfig);
        return client;
    }

    public Map<String, URL> getContainerLogs(Configuration configuration, Map<String, String> customData) {
        String taskArn = customData.get("result.isolated.docker.TaskARN");
        if (taskArn == null) {
            return Collections.emptyMap();
        }
        Stream<String> s = Stream.concat(Stream.of(AGENT_CONTAINER_NAME), configuration.getExtraContainers().stream().map(t -> t.getName()));
        return s.collect(Collectors.toMap(Function.identity(), t -> {
            try {
                URIBuilder bb = new URIBuilder(this.globalConfiguration.getBambooBaseUrl() + "/rest/pbc-ecs-remote/latest/logs").addParameter("containerName", t).addParameter("taskArn", taskArn);
                return bb.build().toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                return null;
            }
        }));
    }

    public List<String> getKnownDockerImages() {
        return Collections.emptyList();
    }

    public void reserveCapacity(Key buildKey, List<String> jobResultKeys, long excessMemoryCapacity, long excessCpuCapacity) {
        if (this.globalConfiguration.isPreemptiveScaling()) {
            Client client = ECSIsolatedAgentServiceImpl.createClient();
            WebResource resource = client.resource(this.globalConfiguration.getCurrentServer() + "/rest/scheduler/future");
            try {
                resource.type(MediaType.APPLICATION_JSON_TYPE).post((Object)this.createFutureReqBody(buildKey, jobResultKeys, excessMemoryCapacity, excessCpuCapacity));
            }
            catch (UniformInterfaceException e) {
                int code = e.getResponse().getClientResponseStatus().getStatusCode();
                String s = "";
                if (e.getResponse().hasEntity()) {
                    s = (String)e.getResponse().getEntity(String.class);
                }
                logger.error("Error contacting ECS wrt future:" + code + " " + s, (Throwable)e);
            }
            catch (ClientHandlerException che) {
                logger.error("Error connecting to ECS wrt future:", (Throwable)che);
            }
            catch (Exception t) {
                logger.error("unknown error", (Throwable)t);
            }
        }
    }

    public void onStart() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("globalConfiguration", this.globalConfiguration);
        config.put("isolatedAgentService", this);
        this.pluginScheduler.scheduleJob(PLUGIN_JOB_KEY, RemoteWatchdogJob.class, config, new Date(), PLUGIN_JOB_INTERVAL_MILLIS);
    }

    public void onStop() {
        this.pluginScheduler.unscheduleJob(PLUGIN_JOB_KEY);
    }

    private String createBody(IsolatedDockerAgentRequest request, GlobalConfiguration globalConfiguration) {
        JsonObject root = new JsonObject();
        root.addProperty("uuid", request.getUniqueIdentifier().toString());
        root.addProperty("queueTimestamp", (Number)request.getQueueTimestamp());
        root.addProperty("resultId", request.getResultKey());
        root.addProperty("bambooServer", globalConfiguration.getBambooBaseUrl());
        root.addProperty("sidekick", globalConfiguration.getCurrentSidekick());
        root.addProperty("taskARN", globalConfiguration.getCurrentRole());
        root.addProperty("buildKey", request.getBuildKey());
        root.add("hostFolderMappings", (JsonElement)this.generateHostFolderMappings());
        root.add("configuration", (JsonElement)ConfigurationPersistence.toJson((Configuration)request.getConfiguration()));
        return root.toString();
    }

    private String createFutureReqBody(Key buildKey, List<String> jobResultKeys, long excessMemoryCapacity, long excessCpuCapacity) {
        JsonObject root = new JsonObject();
        root.addProperty("buildKey", buildKey.getKey());
        JsonArray arr = new JsonArray();
        jobResultKeys.forEach(t -> arr.add((JsonElement)new JsonPrimitive(t)));
        root.add("resultKeys", (JsonElement)arr);
        root.addProperty("cpu", (Number)excessCpuCapacity);
        root.addProperty("memory", (Number)excessMemoryCapacity);
        return root.toString();
    }

    private JsonArray generateHostFolderMappings() {
        JsonArray arr = new JsonArray();
        this.getHostFolderMappings().forEach(t -> {
            JsonObject o = new JsonObject();
            o.addProperty("volumeName", t.getVolumeName());
            o.addProperty("hostPath", t.getHostPath());
            o.addProperty("containerPath", t.getContainerPath());
            arr.add((JsonElement)o);
        });
        return arr;
    }

    public List<HostFolderMapping> getHostFolderMappings() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(HostFolderMappingModuleDescriptor.class).stream().map(t -> (HostFolderMapping)t.getModule()).collect(Collectors.toList());
    }
}

