/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.ecs.remote;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.persister.AuditLogEntry;
import com.atlassian.bamboo.persister.AuditLogMessage;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.buildeng.ecs.remote.rest.Config;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class GlobalConfiguration {
    static String BANDANA_AWS_ROLE_KEY = "com.atlassian.buildeng.ecs.remote.awsrole";
    static String BANDANA_SIDEKICK_KEY = "com.atlassian.buildeng.ecs.remote.sidekick";
    static String BANDANA_SERVER_URL_KEY = "com.atlassian.buildeng.ecs.remote.server";
    static String BANDANA_PREEMPTIVE_KEY = "com.atlassian.buildeng.ecs.remote.preemptive";
    private final BandanaManager bandanaManager;
    private final AdministrationConfigurationAccessor admConfAccessor;
    private final AuditLogService auditLogService;
    private final BambooAuthenticationContext authenticationContext;

    public GlobalConfiguration(BandanaManager bandanaManager, AdministrationConfigurationAccessor admConfAccessor, AuditLogService auditLogService, BambooAuthenticationContext authenticationContext) {
        this.bandanaManager = bandanaManager;
        this.admConfAccessor = admConfAccessor;
        this.auditLogService = auditLogService;
        this.authenticationContext = authenticationContext;
    }

    public String getBambooBaseUrl() {
        return this.admConfAccessor.getAdministrationConfiguration().getBaseUrl();
    }

    public String getCurrentSidekick() {
        return (String)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_SIDEKICK_KEY);
    }

    public String getCurrentRole() {
        return (String)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_AWS_ROLE_KEY);
    }

    public String getCurrentServer() {
        return (String)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_SERVER_URL_KEY);
    }

    public void persist(Config config) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)config.getServerUrl()));
        if (!StringUtils.equals((CharSequence)config.getAwsRole(), (CharSequence)this.getCurrentRole())) {
            this.auditLogEntry("PBC AWS Role", this.getCurrentRole(), config.getAwsRole());
            if (StringUtils.isBlank((CharSequence)config.getAwsRole())) {
                this.bandanaManager.removeValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_AWS_ROLE_KEY);
            } else {
                this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_AWS_ROLE_KEY, (Object)config.getAwsRole());
            }
        }
        if (!StringUtils.equals((CharSequence)config.getSidekickImage(), (CharSequence)this.getCurrentSidekick())) {
            this.auditLogEntry("PBC Sidekick Image", this.getCurrentSidekick(), config.getSidekickImage());
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_SIDEKICK_KEY, (Object)config.getSidekickImage());
        }
        if (!StringUtils.equals((CharSequence)config.getServerUrl(), (CharSequence)this.getCurrentServer())) {
            this.auditLogEntry("PBC Remote Service URL", this.getCurrentServer(), config.getServerUrl());
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_SERVER_URL_KEY, (Object)config.getServerUrl());
        }
        boolean newPremptive = config.isPreemptiveScaling();
        if (this.isPreemptiveScaling() != newPremptive) {
            this.auditLogEntry("PBC Preemptive scaling", "" + this.isPreemptiveScaling(), "" + newPremptive);
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_PREEMPTIVE_KEY, (Object)config.isPreemptiveScaling());
        }
    }

    public boolean isPreemptiveScaling() {
        Boolean val = (Boolean)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, BANDANA_PREEMPTIVE_KEY);
        return val != null ? val : false;
    }

    private void auditLogEntry(String name, String oldValue, String newValue) {
        AuditLogMessage ent = new AuditLogMessage(this.authenticationContext.getUserName(), new Date(), null, null, "FIELD_CHANGE", name, oldValue, newValue);
        this.auditLogService.log((AuditLogEntry)ent);
    }
}

