/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.ecs.remote;

import com.atlassian.buildeng.ecs.remote.ECSIsolatedAgentServiceImpl;
import com.atlassian.buildeng.ecs.remote.GlobalConfiguration;
import com.atlassian.buildeng.ecs.remote.rest.ArnStoppedState;
import com.atlassian.buildeng.ecs.shared.AbstractWatchdogJob;
import com.atlassian.buildeng.ecs.shared.StoppedState;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWatchdogJob
extends AbstractWatchdogJob {
    private static final Logger logger = LoggerFactory.getLogger(RemoteWatchdogJob.class);
    private static int MAXIMUM_ARNS_TO_QUERY = 40;

    protected List<StoppedState> retrieveStoppedTasksByArn(List<String> arns, Map<String, Object> jobDataMap) throws Exception {
        GlobalConfiguration globalConfig = (GlobalConfiguration)this.getService(GlobalConfiguration.class, "globalConfiguration", jobDataMap);
        Client client = ECSIsolatedAgentServiceImpl.createClient();
        ArrayList<StoppedState> tasks = new ArrayList<StoppedState>();
        for (int i = 0; i < arns.size() / MAXIMUM_ARNS_TO_QUERY; ++i) {
            List<String> nextNArns = arns.subList(i * MAXIMUM_ARNS_TO_QUERY, (i + 1) * MAXIMUM_ARNS_TO_QUERY);
            tasks.addAll(this.queryStoppedTasksByArn(globalConfig, client, nextNArns));
        }
        List<String> lastNArns = arns.subList(MAXIMUM_ARNS_TO_QUERY * (arns.size() / MAXIMUM_ARNS_TO_QUERY), arns.size());
        tasks.addAll(this.queryStoppedTasksByArn(globalConfig, client, lastNArns));
        return tasks;
    }

    protected List<StoppedState> queryStoppedTasksByArn(GlobalConfiguration globalConfig, Client client, List<String> arns) {
        WebResource resource = client.resource(globalConfig.getCurrentServer() + "/rest/scheduler/stopped");
        for (String arn : arns) {
            resource = resource.queryParam("arn", arn);
        }
        List result = (List)((WebResource.Builder)resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).type(MediaType.APPLICATION_JSON_TYPE)).get((GenericType)new GenericType<List<ArnStoppedState>>(){});
        return result.stream().map(t -> new StoppedState(t.getArn(), t.getContainerArn(), t.getReason())).collect(Collectors.toList());
    }
}

