/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.ecs.remote;

import com.atlassian.buildeng.ecs.remote.ECSIsolatedAgentServiceImpl;
import com.atlassian.buildeng.ecs.remote.GlobalConfiguration;
import com.atlassian.buildeng.ecs.remote.rest.Config;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.net.URISyntaxException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;

@WebSudoRequired
@Path(value="/")
public class Rest {
    private final GlobalConfiguration configuration;
    static final String PARAM_CONTAINER = "containerName";
    static final String PARAM_TASK_ARN = "taskArn";

    @Autowired
    public Rest(GlobalConfiguration configuration) {
        this.configuration = configuration;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config")
    public Response getConfig() {
        Config c = new Config();
        c.setAwsRole(this.configuration.getCurrentRole());
        c.setServerUrl(this.configuration.getCurrentServer());
        c.setSidekickImage(this.configuration.getCurrentSidekick());
        c.setPreemptiveScaling(this.configuration.isPreemptiveScaling());
        return Response.ok((Object)c).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/config")
    public Response setConfig(Config config) {
        if (StringUtils.isBlank((CharSequence)config.getServerUrl())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"serverUrl is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)config.getSidekickImage())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sidekickImage is mandatory").build();
        }
        this.configuration.persist(config);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/logs")
    @Produces(value={"text/plain"})
    public Response getAwsLogs(@QueryParam(value="containerName") String containerName, @QueryParam(value="taskArn") String taskArn) {
        if (containerName == null || taskArn == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"containerName and taskArn are mandatory").build();
        }
        String server = this.configuration.getCurrentServer();
        if (server == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"remote pbc server not defined in global settings.").build();
        }
        Client client = ECSIsolatedAgentServiceImpl.createClient();
        try {
            URIBuilder uriBuilder = new URIBuilder(this.configuration.getCurrentServer() + "/rest/logs").addParameter(PARAM_CONTAINER, containerName).addParameter(PARAM_TASK_ARN, taskArn);
            WebResource resource = client.resource(uriBuilder.build());
            return Response.ok().entity(((WebResource.Builder)resource.accept(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).type(MediaType.TEXT_PLAIN_TYPE)).get(String.class)).build();
        }
        catch (URISyntaxException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Error constructing URI to pbc-service").build();
        }
    }
}

