/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.authentication.impl;

import com.atlassian.crowd.directory.authentication.AdalAuthenticationContextFactory;
import com.atlassian.crowd.directory.authentication.UserCredentialVerifier;
import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.google.common.util.concurrent.MoreExecutors;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class SameThreadUserCredentialVerifier
implements UserCredentialVerifier {
    private final ExecutorService sameThreadService = MoreExecutors.newDirectExecutorService();
    private final AdalAuthenticationContextFactory adalAuthenticationContextFactory;
    private final AzureApiUriResolver endpointDataProvider;
    private final String tenantIt;
    private final String nativeClientId;

    public SameThreadUserCredentialVerifier(AdalAuthenticationContextFactory adalAuthenticationContextFactory, AzureApiUriResolver endpointDataProvider, String nativeClientId, String tenantId) {
        this.adalAuthenticationContextFactory = adalAuthenticationContextFactory;
        this.nativeClientId = nativeClientId;
        this.endpointDataProvider = endpointDataProvider;
        this.tenantIt = tenantId;
    }

    @Override
    public void checkUserCredential(String username, PasswordCredential userCredential) throws InvalidAuthenticationException, OperationFailedException {
        AuthenticationContext authenticationContext = this.adalAuthenticationContextFactory.create(this.endpointDataProvider.getAuthorityApiUrl(this.tenantIt), this.sameThreadService);
        try {
            authenticationContext.acquireToken(this.endpointDataProvider.getGraphApiUrl(), this.nativeClientId, username, userCredential.getCredential(), null).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AuthenticationException) {
                throw new InvalidAuthenticationException("could not authenticate user " + username, (Throwable)e);
            }
            throw new OperationFailedException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }
}

