/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.directory.AzureAdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.AbstractDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.AzureAdDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.RemoteDirectoryInstanceFactoryUtil;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.util.InstanceFactory;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAdDirectoryInstanceLoaderImpl
extends AbstractDirectoryInstanceLoader
implements AzureAdDirectoryInstanceLoader {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final InstanceFactory instanceFactory;

    public AzureAdDirectoryInstanceLoaderImpl(InstanceFactory instanceFactory) {
        this.instanceFactory = (InstanceFactory)Preconditions.checkNotNull((Object)instanceFactory);
    }

    public RemoteDirectory getRawDirectory(Long id, String className, Map<String, String> attributes) throws DirectoryInstantiationException {
        return RemoteDirectoryInstanceFactoryUtil.newRemoteDirectory((InstanceFactory)this.instanceFactory, (Long)id, (String)className, attributes);
    }

    public boolean canLoad(String className) {
        try {
            return AzureAdDirectory.class.isAssignableFrom(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Could not load class <" + className + ">", (Throwable)e);
            return false;
        }
    }
}

