/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.group;

import com.atlassian.crowd.attribute.AttributeUtil;
import com.atlassian.crowd.model.group.BaseImmutableGroup;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ImmutableGroupWithAttributes
extends BaseImmutableGroup
implements GroupWithAttributes {
    private final Map<String, Set<String>> attributes;

    private ImmutableGroupWithAttributes(Builder builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public static ImmutableGroupWithAttributes from(GroupWithAttributes group) {
        if (group instanceof ImmutableGroupWithAttributes) {
            return (ImmutableGroupWithAttributes)group;
        }
        return ImmutableGroupWithAttributes.builder(group).build();
    }

    public static Builder builder(GroupWithAttributes group) {
        return ImmutableGroupWithAttributes.builder(group, AttributeUtil.toMap(group));
    }

    public static Builder builder(Group group, Map<String, Set<String>> attributes) {
        return new Builder(group, attributes);
    }

    public Set<String> getValues(String key) {
        return this.attributes.getOrDefault(key, new HashSet());
    }

    public String getValue(String key) {
        Set<String> values = this.getValues(key);
        return values.isEmpty() ? null : values.iterator().next();
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public ImmutableGroupWithAttributes withName(String name) {
        return ((Builder)ImmutableGroupWithAttributes.builder(this).setName(name)).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableGroupWithAttributes that = (ImmutableGroupWithAttributes)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.attributes);
    }

    public static class Builder
    extends BaseImmutableGroup.Builder<Builder> {
        private Map<String, Set<String>> attributes;

        public Builder(Group group, Map<String, Set<String>> attributes) {
            super(group);
            this.setAttributes(attributes);
        }

        public Builder setAttributes(Map<String, Set<String>> attributes) {
            this.attributes = new HashMap<String, Set<String>>(attributes);
            return this;
        }

        @Override
        public ImmutableGroupWithAttributes build() {
            return new ImmutableGroupWithAttributes(this);
        }
    }
}

