/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.service;

import com.atlassian.crowd.integration.rest.service.AuthStrategy;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthStrategy
implements AuthStrategy {
    private CredentialsProvider credsProvider;
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthStrategy.class);

    public BasicAuthStrategy(CredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
    }

    @Override
    public HttpResponse executeRequest(HttpUriRequest request, CloseableHttpClient client, HttpHost httpHost) throws IOException {
        HttpCacheContext context = this.createContext(httpHost);
        CloseableHttpResponse response = client.execute(request, (HttpContext)context);
        logger.debug("Cache response for {} {} was {}", new Object[]{request.getMethod(), request.getURI(), context.getCacheResponseStatus()});
        return response;
    }

    private HttpCacheContext createContext(HttpHost httpHost) {
        HttpCacheContext context = HttpCacheContext.create();
        context.setCredentialsProvider(this.credsProvider);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(httpHost, (AuthScheme)basicAuth);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }
}

