/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.DirectoryEntities;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDirectoryCacheRefresher
extends AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(RemoteDirectoryCacheRefresher.class);
    public static final EntityQuery<GroupWithAttributes> ALL_REMOTE_GROUPS_QUERY = QueryBuilder.queryFor(GroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1);

    public RemoteDirectoryCacheRefresher(RemoteDirectory remoteDirectory) {
        super(remoteDirectory);
    }

    @Override
    public boolean synchroniseChanges(DirectoryCache directoryCache) throws OperationFailedException {
        return false;
    }

    private List<UserWithAttributes> findAllRemoteUsers(boolean withAttributes) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading remote users");
        List<UserWithAttributes> users = withAttributes ? this.remoteDirectory.searchUsers(this.getUserQuery(UserWithAttributes.class)) : this.remoteDirectory.searchUsers(this.getUserQuery(User.class)).stream().map(UserTemplateWithAttributes::toUserWithNoAttributes).collect(Collectors.toList());
        log.info("found [ {} ] remote users in [ {} ms ]", (Object)users.size(), (Object)(System.currentTimeMillis() - start));
        return users;
    }

    private <T extends User> EntityQuery<T> getUserQuery(Class<T> clazz) {
        return QueryBuilder.queryFor(clazz, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
    }

    private List<GroupWithAttributes> findAllRemoteGroups() throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading remote groups");
        List groups = this.remoteDirectory.searchGroups(ALL_REMOTE_GROUPS_QUERY);
        log.info("found [ {} ] remote groups in [ {} ms ]", (Object)groups.size(), (Object)(System.currentTimeMillis() - start));
        return groups;
    }

    @Override
    protected List<? extends UserWithAttributes> synchroniseAllUsers(DirectoryCache directoryCache, boolean withAttributes) throws OperationFailedException {
        Date syncStartDate = new Date();
        List<UserWithAttributes> ldapUsers = this.findAllRemoteUsers(withAttributes);
        directoryCache.deleteCachedUsersNotIn(ldapUsers, syncStartDate);
        directoryCache.addOrUpdateCachedUsers(ldapUsers, syncStartDate);
        return ldapUsers;
    }

    @Override
    protected List<? extends GroupWithAttributes> synchroniseAllGroups(DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        List groups = DirectoryEntities.filterOutDuplicates(this.findAllRemoteGroups());
        directoryCache.deleteCachedGroupsNotIn(GroupType.GROUP, groups, syncStartDate);
        directoryCache.addOrUpdateCachedGroups(groups, syncStartDate);
        return groups;
    }
}

