/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.cache.Cache;
import com.atlassian.crowd.model.application.Application;
import java.net.InetAddress;
import javax.annotation.Nullable;

public class InetAddressCacheUtil {
    public static final String INET_ADDRESS_CACHE_NAME = InetAddressCacheUtil.class.getName() + "_cache";
    private final Cache<String, Boolean> cache;

    public InetAddressCacheUtil(Cache<String, Boolean> cache) {
        this.cache = cache;
    }

    public void setPermitted(Application application, InetAddress address, boolean permitted) {
        this.cache.put((Object)InetAddressCacheUtil.getKeyName(application, address), (Object)permitted);
    }

    @Nullable
    public Boolean getPermitted(Application application, InetAddress address) {
        return (Boolean)this.cache.get((Object)InetAddressCacheUtil.getKeyName(application, address));
    }

    public void clearCache() {
        this.cache.removeAll();
    }

    private static String getKeyName(Application application, InetAddress address) {
        return application.getName() + "#" + address.getHostAddress();
    }
}

