/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.api.Attributes;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ImmutableAttributes
implements Attributes,
Serializable {
    private static final long serialVersionUID = -356796362241352598L;
    private final Map<String, Set<String>> map;

    public ImmutableAttributes() {
        this.map = Collections.emptyMap();
    }

    public ImmutableAttributes(@Nonnull Map<String, Set<String>> attributesMap) {
        this.map = ImmutableAttributes.immutableCopyOf(attributesMap);
    }

    public ImmutableAttributes(@Nonnull Attributes attributes) {
        HashMap<String, Set<String>> tempMap = new HashMap<String, Set<String>>();
        for (String key : attributes.getKeys()) {
            tempMap.put(key, Collections.unmodifiableSet(new HashSet<String>(attributes.getValues(key))));
        }
        this.map = Collections.unmodifiableMap(tempMap);
    }

    @Override
    public Set<String> getValues(String key) {
        return this.map.get(key);
    }

    @Override
    public String getValue(String key) {
        Set<String> values = this.getValues(key);
        if (values == null) {
            return null;
        }
        return values.iterator().next();
    }

    @Override
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private static Map<String, Set<String>> immutableCopyOf(Map<String, Set<String>> source) {
        HashMap tempMap = new HashMap();
        for (Map.Entry<String, Set<String>> entry : source.entrySet()) {
            tempMap.put(entry.getKey(), Collections.unmodifiableSet(new HashSet(entry.getValue())));
        }
        return Collections.unmodifiableMap(tempMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAttributes that = (ImmutableAttributes)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

