/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extension.provider.base;

import com.atlassian.extension.provider.api.ExtensionTag;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtensionTags {
    @Nonnull
    public static ExtensionTag createOpaque() {
        return new ExtensionTag(){};
    }

    @Nonnull
    public static <V> Function<V, ExtensionTag> createValueTagFactory(Class<V> valueClass) {
        ValueExtensionTag.Helper helper = new ValueExtensionTag.Helper(valueClass.getName());
        return value -> new ValueExtensionTag<Object>(helper, value);
    }

    private static class ValueExtensionTag<V>
    implements ExtensionTag {
        private final Helper<V> helper;
        private final V value;

        public ValueExtensionTag(Helper<V> helper, @Nullable V value) {
            this.helper = helper;
            this.value = value;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ValueExtensionTag that = (ValueExtensionTag)other;
            return this.helper == that.helper && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.helper, this.value);
        }

        @Nonnull
        public String toString() {
            return this.helper.valueExtensionTagToString(this.value);
        }

        static class Helper<V> {
            private final String toStringPrefix;

            public Helper(String valueClassName) {
                String helperName = Integer.toHexString(System.identityHashCode(this));
                this.toStringPrefix = "ValueExtensionTag<" + valueClassName + ">(Helper@" + helperName + ",";
            }

            @Nonnull
            String valueExtensionTagToString(@Nullable V value) {
                return this.toStringPrefix + String.valueOf(value) + ")";
            }
        }
    }
}

