/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extension.provider.base;

import com.atlassian.extension.provider.api.ExtensionProvider;
import com.atlassian.extension.provider.api.ExtensionTag;
import com.atlassian.extension.provider.base.ExtensionTags;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class SimpleExtensionProvider
implements ExtensionProvider {
    private final Map<Class, ExtensionTag.Tagged> extensionsByClass = new HashMap<Class, ExtensionTag.Tagged>();

    @Nonnull
    public <E> ExtensionTag.Tagged<Iterable<E>> getExtensionsByClass(Class<E> extensionClass, Predicate<ExtensionTag> cached) {
        ExtensionTag.Tagged results = this.extensionsByClass.get(extensionClass);
        if (null == results) {
            ImmutableList empty = ImmutableList.of();
            return this.tagAndUpdateExtensions(extensionClass, (Iterable<E>)empty);
        }
        ExtensionTag extensionTag = results.getTag();
        if (cached.test(extensionTag)) {
            return new ExtensionTag.Tagged(extensionTag);
        }
        return results;
    }

    public <E> void setExtensionsByClass(Class<E> extensionClass, Iterable<E> extensions) {
        this.tagAndUpdateExtensions(extensionClass, extensions);
    }

    private <E> ExtensionTag.Tagged<Iterable<E>> tagAndUpdateExtensions(Class<E> extensionClass, Iterable<E> extensions) {
        ExtensionTag tag = ExtensionTags.createOpaque();
        ExtensionTag.Tagged taggedExtensions = new ExtensionTag.Tagged(tag, extensions);
        this.extensionsByClass.put(extensionClass, taggedExtensions);
        return taggedExtensions;
    }
}

