/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jpo.env.test.utils.User;
import com.atlassian.jpo.env.test.utils.WiredIntegrationTestClassRule;
import com.atlassian.jpo.env.test.utils.WiredIntegrationTestMethodRule;
import com.atlassian.jpo.env.test.utils.WiredTestRuleFactory;
import com.atlassian.jpo.env.test.utils.annotations.AgileRequirements;
import com.atlassian.jpo.env.test.utils.annotations.Login;
import com.atlassian.jpo.env.test.utils.annotations.Projects;
import com.atlassian.jpo.jira.api.issue.IssueServiceBridge;
import com.atlassian.jpo.jira.api.issue.IssueServiceBridgeProxy;
import com.atlassian.jpo.jira.api.issue.link.IssueLinkServiceBridge;
import com.atlassian.jpo.jira.api.issue.link.IssueLinkServiceBridgeProxy;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.workitems.IssueLinkRequest;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import it.testdata.ScrumProject;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AtlassianPluginsTestRunner.class)
public class WorkItemExtensionCreateDpsWithoutMatchingIssuesTest {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final WorkItemExtension workItemExtension;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueServiceBridgeProxy issueServiceBridgeProxy;
    private final IssueLinkServiceBridgeProxy issueLinkServiceBridgeProxy;

    public WorkItemExtensionCreateDpsWithoutMatchingIssuesTest(WorkItemExtension workItemExtension, JiraAuthenticationContext authenticationContext, IssueLinkTypeManager issueLinkTypeManager, IssueServiceBridgeProxy issueServiceBridgeProxy, IssueLinkServiceBridgeProxy issueLinkServiceBridge) {
        this.workItemExtension = workItemExtension;
        this.authenticationContext = authenticationContext;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueServiceBridgeProxy = issueServiceBridgeProxy;
        this.issueLinkServiceBridgeProxy = issueLinkServiceBridge;
    }

    @Test
    @Login(user=User.ADMIN)
    @AgileRequirements(installed=true)
    @Projects(value={ScrumProject.class})
    public void testCreateDependenciesWithoutMatchingIssues() throws Exception {
        IssueLinkRequest request = new IssueLinkRequest(){

            public List<String> getInwardIds() {
                return Lists.newArrayList();
            }

            public List<String> getOutwardIds() {
                return Lists.newArrayList();
            }

            public Set<String> getIssueKeys() {
                return Sets.newHashSet((Object[])new String[]{"SCRUM-1"});
            }

            public String getLinkTypeId() {
                return "10000";
            }
        };
        this.workItemExtension.createIssueLinksForDependencies(request);
        ApplicationUser authenticatedUser = this.authenticationContext.getUser();
        MutableIssue targetIssue = ((IssueServiceBridge)this.issueServiceBridgeProxy.get()).getIssue(authenticatedUser, "SCRUM-1").getIssue();
        IssueLinkService.IssueLinkResult linkResult = ((IssueLinkServiceBridge)this.issueLinkServiceBridgeProxy.get()).getIssueLinks(authenticatedUser, (Issue)targetIssue);
        Assert.assertNotNull((Object)linkResult);
        Assert.assertTrue((boolean)linkResult.getLinkCollection().getAllIssues().isEmpty());
    }
}

