/*
 * Decompiled with CFR 0.152.
 */
package it.testdata;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jpo.env.test.utils.DisposableProjectDefinition;
import com.atlassian.jpo.env.test.utils.WiredTestUtils;
import it.testutils.PermissionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ReadOnlyToNonAdminProject
implements DisposableProjectDefinition {
    private final PermissionUtils permissionUtils;
    private Scheme restrictedPermissionsScheme;

    @Autowired
    public ReadOnlyToNonAdminProject(PermissionUtils permissionUtils) throws Exception {
        this.permissionUtils = permissionUtils;
    }

    public void cleanup(Project project) throws Exception {
        this.permissionUtils.removeSchemesFromProject(project);
        this.permissionUtils.deletePermissionsScheme(this.restrictedPermissionsScheme);
    }

    public Project instantiate(WiredTestUtils utils) throws Exception {
        Project project = utils.getProjectUtils().createStandardProject(utils.getLoginManager().getLoggedInUser(), "Readonly to Non-Admin", "RTNA");
        utils.getVersionUtils().createVersionInProject("X", project);
        this.restrictedPermissionsScheme = this.permissionUtils.createRestrictedPermissionsScheme();
        this.permissionUtils.addSchemeToProject(project, this.restrictedPermissionsScheme);
        return project;
    }
}

