/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jpo.agile.api.license.AgileLicenseServiceBridge;
import com.atlassian.jpo.agile.api.license.AgileLicenseServiceBridgeProxy;
import com.atlassian.jpo.env.test.utils.WiredIntegrationTestClassRule;
import com.atlassian.jpo.env.test.utils.WiredIntegrationTestMethodRule;
import com.atlassian.jpo.env.test.utils.WiredTestRuleFactory;
import com.atlassian.jpo.env.test.utils.annotations.AgileLicensing;
import com.atlassian.jpo.env.test.utils.annotations.AgileRequirements;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AtlassianPluginsTestRunner.class)
public class JiraAgileTest {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final JiraAgileAccessor agileAccessor;
    private final AgileLicenseServiceBridgeProxy licenseServiceBridgeProxy;

    public JiraAgileTest(JiraAgileAccessor agileAccessor, AgileLicenseServiceBridgeProxy licenseServiceBridgeProxy) {
        this.agileAccessor = agileAccessor;
        this.licenseServiceBridgeProxy = licenseServiceBridgeProxy;
    }

    @Test
    @AgileRequirements(installed=true)
    public void testAvailable() {
        Assert.assertTrue((boolean)this.agileAccessor.isAvailable());
    }

    @Test
    @AgileRequirements(installed=false)
    public void testUnavailable() {
        Assert.assertFalse((boolean)this.agileAccessor.isAvailable());
    }

    @Test
    @AgileRequirements(installed=true, licensed=AgileLicensing.Unlicensed)
    public void testAvailableAndNotLicensed() throws Exception {
        ((AgileLicenseServiceBridge)this.licenseServiceBridgeProxy.get()).setCheckEnabled(true);
        Assert.assertFalse((boolean)this.agileAccessor.isUsable());
        ((AgileLicenseServiceBridge)this.licenseServiceBridgeProxy.get()).setCheckEnabled(false);
    }

    @Test
    @AgileRequirements(installed=true, licensed=AgileLicensing.Licensed)
    public void testAvailableAndLicensedWithCheckDisabled() throws Exception {
        ((AgileLicenseServiceBridge)this.licenseServiceBridgeProxy.get()).setCheckEnabled(false);
        Assert.assertTrue((boolean)this.agileAccessor.isUsable());
    }
}

