/*
 * Decompiled with CFR 0.152.
 */
package it.lucene;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jpo.agile.api.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.jpo.env.test.utils.User;
import com.atlassian.jpo.env.test.utils.WiredIntegrationTestClassRule;
import com.atlassian.jpo.env.test.utils.WiredIntegrationTestMethodRule;
import com.atlassian.jpo.env.test.utils.WiredTestRuleFactory;
import com.atlassian.jpo.env.test.utils.annotations.Login;
import com.atlassian.jpo.env.test.utils.annotations.Projects;
import com.atlassian.jpo.env.test.utils.tools.IssueInputCallback;
import com.atlassian.jpo.env.test.utils.tools.IssueType;
import com.atlassian.jpo.jira.api.issue.IssueServiceBridgeProxy;
import com.atlassian.jpo.jira.api.issue.SubtaskManagerBridge;
import com.atlassian.jpo.jira.api.issue.SubtaskManagerBridgeProxy;
import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFieldsService;
import it.lucene.BaseLuceneExtensionLinkDataTest;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=AtlassianPluginsTestRunner.class)
public class SubtaskLuceneExtensionLinkDataTest
extends BaseLuceneExtensionLinkDataTest {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final SubtaskManagerBridgeProxy subtaskManagerBridgeProxy;

    public SubtaskLuceneExtensionLinkDataTest(IssueServiceBridgeProxy issueServiceBridgeVersionProxy, AgileCustomFieldsServiceBridgeProxy agileCustomFieldsServiceBridgeProxy, SubtaskManagerBridgeProxy subtaskManagerBridgeProxy, CustomFieldsService customFields, IssueTypeManager issueTypeManager, JiraAuthenticationContext authenticationContext, IssueService issueService, IssueIndexManager issueIndexManager, WorklogService worklogService, WorkItemExtension workItemExtension) {
        super(issueServiceBridgeVersionProxy, agileCustomFieldsServiceBridgeProxy, customFields, issueTypeManager, authenticationContext, issueService, issueIndexManager, worklogService, workItemExtension);
        this.subtaskManagerBridgeProxy = subtaskManagerBridgeProxy;
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={BaseLuceneExtensionLinkDataTest.LuceneExtensionTestProjectDefinition.class})
    public void testSubtaskGet() throws Exception {
        ApplicationUser user = this.authenticationContext.getUser();
        ProgressConfiguration progressConfiguration = (ProgressConfiguration)Mockito.mock(ProgressConfiguration.class);
        Mockito.when((Object)progressConfiguration.getTrackerType()).thenReturn((Object)TrackerType.TimeBased);
        Project project = this.wiredIntegrationTestRule.getProject(BaseLuceneExtensionLinkDataTest.LuceneExtensionTestProjectDefinition.class);
        HashSet issueKeys = Sets.newHashSet();
        Issue parent = this.wiredIntegrationTestRule.getWiredTestUtils().getIssueUtils().createIssue(project, user, IssueType.TASK, 0L);
        Issue subtask = this.wiredIntegrationTestRule.getWiredTestUtils().getIssueUtils().createSubtask(project, user, IssueType.SUBTASK, 240L, parent.getId(), new IssueInputCallback(){

            public void apply(IssueInputParameters inputParameters) {
            }
        });
        ((SubtaskManagerBridge)this.subtaskManagerBridgeProxy.get()).createSubTaskIssueLink(parent, subtask);
        this.createWorklog(subtask, "2h");
        this.issueIndexManager.reIndex(parent);
        this.issueIndexManager.reIndex(subtask);
        this.issueIndexManager.reIndexAll();
        issueKeys.add(parent.getKey());
        MonitoredCallResult monitoredCallResult = this.workItemExtension.getExtensionLinkData(progressConfiguration, (Set)issueKeys);
        WorkItemExtensionLinkData data = (WorkItemExtensionLinkData)monitoredCallResult.getResult();
        Assert.assertNotNull((Object)data.getFullProgress(parent.getKey()));
        Assert.assertEquals((double)0.0, (double)data.getProgress(parent.getKey()).getDonePercentage(), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)data.getFullProgress(parent.getKey()).getDonePercentage(), (double)1.0E-5);
        Assert.assertEquals((Object)false, (Object)data.getStatusData(parent.getKey()).isDone());
    }
}

