/*
 * Decompiled with CFR 0.152.
 */
package it;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import it.login.Login;
import it.login.User;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class BaseIntegrationTest {
    @Rule
    public TestRule watchman = new TestWatcher(){

        protected void starting(Description description) {
            Login login = (Login)description.getAnnotation(Login.class);
            User user = login != null ? login.user() : User.ADMIN;
            ApplicationUser admin = BaseIntegrationTest.this.userManager.getUserByName(user.getUsername());
            com.atlassian.crowd.embedded.api.User directoryUser = admin.getDirectoryUser();
            BaseIntegrationTest.this.loginService.authenticate(admin.getDirectoryUser(), user.getPassword());
            BaseIntegrationTest.this.authenticationContext.setLoggedInUser(directoryUser);
            BaseIntegrationTest.this.loginService.authenticate(BaseIntegrationTest.this.authenticationContext.getUser().getDirectoryUser(), user.getPassword());
            BaseIntegrationTest.this.user = BaseIntegrationTest.this.authenticationContext.getUser();
        }
    };
    private static final String ID_FIELD = "id";
    public static final String DEFAULT_PROJECT_NAME = "dpk";
    public static final String DEFAULT_PROJECT_KEY = "DPK";
    private final JiraAuthenticationContext authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    private final UserManager userManager = ComponentAccessor.getUserManager();
    private final LoginService loginService;
    private final ProjectService projectService;
    private final IssueSecuritySchemeManager securitySchemeManager;
    private final PermissionSchemeManager permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
    protected ApplicationUser user;

    public BaseIntegrationTest() {
        this.loginService = (LoginService)ComponentAccessor.getComponent(LoginService.class);
        this.projectService = (ProjectService)ComponentAccessor.getComponent(ProjectService.class);
        this.securitySchemeManager = (IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withProject(Function func) throws Exception {
        if (this.projectService == null) {
            throw new Exception("Project service not available.");
        }
        Project project = null;
        try {
            ProjectService.CreateProjectValidationResult createProjectValidationResult = this.projectService.validateCreateProject(this.user.getDirectoryUser(), DEFAULT_PROJECT_NAME, DEFAULT_PROJECT_KEY, "Foo", this.user.getDirectoryUser().getName(), "http://www.atlassian.com", null);
            project = this.projectService.createProject(createProjectValidationResult);
            ProjectService.UpdateProjectSchemesValidationResult schemeValidationResult = this.projectService.validateUpdateProjectSchemes(this.user.getDirectoryUser(), this.getPermissionSchemeId(), null, this.getSecuritySchemeId());
            this.projectService.updateProjectSchemes(schemeValidationResult, project);
            func.apply(project);
        }
        finally {
            if (project != null) {
                ProjectService.DeleteProjectValidationResult deleteValidationResult = this.projectService.validateDeleteProject(this.user, DEFAULT_PROJECT_KEY);
                this.projectService.deleteProject(this.user, deleteValidationResult);
            }
        }
    }

    private Long getSecuritySchemeId() throws GenericEntityException {
        GenericValue defaultScheme = this.securitySchemeManager.getDefaultScheme();
        return BaseIntegrationTest.getLong(defaultScheme, ID_FIELD);
    }

    private Long getPermissionSchemeId() throws GenericEntityException {
        GenericValue defaultScheme = this.permissionSchemeManager.getDefaultScheme();
        return BaseIntegrationTest.getLong(defaultScheme, ID_FIELD);
    }

    private static Long getLong(GenericValue gv, String fieldName) {
        if (gv == null) {
            return null;
        }
        Object o = gv.get(fieldName);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return (long)((Integer)o);
        }
        if (o instanceof String) {
            try {
                return Long.valueOf((String)o);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected static interface Function {
        public void apply(Project var1) throws Exception;
    }
}

