/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.project;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.project.ProjectCreationData;
import com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridge;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.project.ProjectServiceBridge812")
@SupportedVersions(all=true)
public class ProjectServiceBridge812
implements ProjectServiceBridge {
    private final ProjectService projectService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;

    @Autowired
    public ProjectServiceBridge812(ProjectService projectService, I18nHelper.BeanFactory i18nFactory, ProjectManager projectManager, PermissionManager permissionManager) {
        this.projectService = projectService;
        this.i18nFactory = i18nFactory;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public ProjectService.CreateProjectValidationResult validateCreateProject(ApplicationUser user, ProjectCreationData projectCreationData) {
        return this.projectService.validateCreateProject(user, new ProjectCreationData.Builder().withName(projectCreationData.getName()).withKey(projectCreationData.getKey()).withDescription(projectCreationData.getDescription()).withLead(projectCreationData.getLead()).withUrl(projectCreationData.getUrl()).withAssigneeType(projectCreationData.getAssigneeType()).withAvatarId(projectCreationData.getAvatarId()).withProjectTemplateKey(projectCreationData.getProjectTemplateKey().getKey()).build());
    }

    @Override
    public Project createProject(ProjectService.CreateProjectValidationResult result) {
        return this.projectService.createProject(result);
    }

    @Override
    public ProjectService.DeleteProjectValidationResult validateDeleteProject(ApplicationUser user, String projectKey) {
        return this.projectService.validateDeleteProject(user, projectKey);
    }

    @Override
    public void deleteProject(ApplicationUser user, ProjectService.DeleteProjectValidationResult result) {
        this.projectService.deleteProject(user, result);
    }

    @Override
    public ProjectService.GetProjectResult getProjectById(ApplicationUser user, long projectId) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectById(user, Long.valueOf(projectId));
        if (getProjectResult.isValid() && getProjectResult.get().isArchived()) {
            return new ProjectService.GetProjectResult(this.makeNotFoundError(user, "admin.errors.project.not.found.for.id", String.valueOf(projectId)));
        }
        return getProjectResult;
    }

    @Override
    public ProjectService.GetProjectResult getProjectByKey(ApplicationUser user, String projectKey) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByKey(user, projectKey);
        if (getProjectResult.isValid() && getProjectResult.get().isArchived()) {
            return new ProjectService.GetProjectResult(this.makeNotFoundError(user, "admin.errors.project.not.found.for.key", projectKey));
        }
        return getProjectResult;
    }

    private ErrorCollection makeNotFoundError(ApplicationUser user, String i18nKey, String ... params) {
        ErrorCollection errors = ErrorCollections.empty();
        I18nHelper i18nBean = this.i18nFactory.getInstance(user);
        errors.addErrorMessage(i18nBean.getText(i18nKey, (Object)params), ErrorCollection.Reason.NOT_FOUND);
        return errors;
    }

    @Override
    public ServiceOutcome<List<Project>> getAllProjects(ApplicationUser user) {
        List projects = this.projectManager.getProjectObjects().stream().filter(project -> project != null && this.hasBrowsePermission(user, (Project)project)).collect(Collectors.toList());
        return new ServiceOutcomeImpl(ErrorCollections.empty(), projects);
    }

    private boolean hasBrowsePermission(ApplicationUser user, Project project) {
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user);
    }
}

