/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.threading;

import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.threading.JiraSafeThreadService;
import com.atlassian.rm.common.bridges.jira.threading.LocalThreadPoolLongRunningTaskState;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningExecutorRegistryBridge812;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningExecutorServiceBridge;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTask;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTaskCallback;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTaskData;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTaskProgress;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTaskProvider;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTaskState;
import com.atlassian.rm.common.bridges.jira.threading.UnregisteredLongRunningTaskProviderException;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.threading.LongRunningExecutorServiceBridge812")
@SupportedVersions(all=true)
class LongRunningExecutorServiceBridge812
implements LongRunningExecutorServiceBridge {
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);
    private final LongRunningExecutorRegistryBridge812 executorRegistry;
    private final JiraSafeThreadService jiraSafeThreadService;
    private final Cache<String, LongRunningTaskData> taskCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    static LongRunningTaskCallback dummyCallback = new LongRunningTaskCallback(){

        @Override
        public void heartbeat() {
        }

        @Override
        public void progress(long progressAsPercent) {
        }
    };

    @Autowired
    public LongRunningExecutorServiceBridge812(LongRunningExecutorRegistryBridge812 executorRegistry, JiraSafeThreadService jiraSafeThreadService) {
        this.executorRegistry = executorRegistry;
        this.jiraSafeThreadService = jiraSafeThreadService;
    }

    @Override
    public void execute(String key, String payload) throws Exception {
        this.execute(key, payload, dummyCallback);
    }

    @Override
    public void execute(String key, String payload, LongRunningTaskCallback callback) throws Exception {
        LongRunningTask task = this.getTask(key, payload);
        this.execute(task, callback);
    }

    @Override
    public String executeWithProgress(String key, String payload) throws Exception {
        LongRunningTask task = this.getTask(key, payload);
        String taskId = UUID.randomUUID().toString();
        final LongRunningTaskProgress state = new LongRunningTaskProgress();
        Future<String> future = this.execute(task, new LongRunningTaskCallback(){

            @Override
            public void heartbeat() {
            }

            @Override
            public void progress(long progressAsPercent) {
                state.setProgressInPercent(progressAsPercent);
            }
        });
        this.taskCache.put((Object)taskId, (Object)new LongRunningTaskData(future, state));
        return taskId;
    }

    @Override
    public Optional<LongRunningTaskState> poll(String taskId) throws Exception {
        LongRunningTaskData taskData = (LongRunningTaskData)this.taskCache.getIfPresent((Object)taskId);
        if (taskData == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new LocalThreadPoolLongRunningTaskState(taskData));
    }

    private Future<String> execute(LongRunningTask task, LongRunningTaskCallback callback) {
        return this.jiraSafeThreadService.execute(this.executorService, () -> task.run(callback));
    }

    private LongRunningTask getTask(String key, String payload) throws Exception {
        Map<String, LongRunningTaskProvider> longRunningTaskProviders = this.executorRegistry.getLongRunningTaskProviders();
        if (!longRunningTaskProviders.containsKey(key)) {
            throw new UnregisteredLongRunningTaskProviderException("There is no LongRunningTaskProvider registered for the key = " + key);
        }
        return longRunningTaskProviders.get(key).getLongRunningTask(payload);
    }
}

