/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.time;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.time.TimeZoneServiceBridge;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.time.TimeZoneServiceBridge812")
@SupportedVersions(all=true)
class TimeZoneServiceBridge812
implements TimeZoneServiceBridge {
    private static final Log LOGGER = Log.with(TimeZoneServiceBridge812.class);
    private static final String JIRA_SPECIFIC_UTC_REPLACEMENT = "Etc/GMT";
    private final TimeZoneManager timeZoneManager;
    private final TimeZoneService timeZoneService;

    @Autowired
    public TimeZoneServiceBridge812(TimeZoneManager timeZoneManager, TimeZoneService timeZoneService) {
        this.timeZoneManager = timeZoneManager;
        this.timeZoneService = timeZoneService;
    }

    @Override
    public TimeZone getDefaultTimeZone() {
        return this.timeZoneManager.getDefaultTimezone();
    }

    @Override
    public void setDefaultTimeZone(TimeZone timeZone, ApplicationUser user) {
        LOGGER.debug("set default time zone: %s", timeZone);
        if (timeZone.getID().equals("UTC")) {
            this.timeZoneService.setDefaultTimeZone(JIRA_SPECIFIC_UTC_REPLACEMENT, (JiraServiceContext)new JiraServiceContextImpl(user));
        } else {
            this.timeZoneService.setDefaultTimeZone(timeZone.getID(), (JiraServiceContext)new JiraServiceContextImpl(user));
        }
    }

    @Override
    public void setUserTimeZone(TimeZone timeZone, ApplicationUser user) {
        LOGGER.debug("set user default time zone: %s", timeZone);
        if (timeZone.getID().equals("UTC")) {
            this.timeZoneService.setUserDefaultTimeZone(JIRA_SPECIFIC_UTC_REPLACEMENT, (JiraServiceContext)new JiraServiceContextImpl(user));
        } else {
            this.timeZoneService.setUserDefaultTimeZone(timeZone.getID(), (JiraServiceContext)new JiraServiceContextImpl(user));
        }
    }

    @Override
    public TimeZoneInfo getDefaultTimeZoneInfo(ApplicationUser user) {
        return this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(user));
    }

    @Override
    public List<RegionInfo> getTimeZoneRegions(ApplicationUser user) {
        LOGGER.debug("get time zone regions", new Object[0]);
        return this.timeZoneService.getTimeZoneRegions((JiraServiceContext)new JiraServiceContextImpl(user));
    }

    @Override
    public List<TimeZoneInfo> getTimeZoneInfos(Optional<String> regionKey, ApplicationUser user) {
        LOGGER.debug("requested time zone information for region %s", regionKey);
        if (!regionKey.isPresent()) {
            LOGGER.debug("return default timezone information", new Object[0]);
            return Lists.newArrayList((Object[])new TimeZoneInfo[]{this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(user))});
        }
        ArrayList filtered = Lists.newArrayList();
        String regionKeyOrDefault = (String)regionKey.or((Object)this.timeZoneService.getDefaultTimeZoneRegionKey());
        for (TimeZoneInfo timeZoneInfo : this.timeZoneService.getTimeZoneInfos((JiraServiceContext)new JiraServiceContextImpl(user))) {
            if (!timeZoneInfo.getRegionKey().equalsIgnoreCase(regionKeyOrDefault)) continue;
            filtered.add(timeZoneInfo);
        }
        LOGGER.debug("return %d time zone information objects: %s", filtered.size(), Joiner.on((String)",").join((Iterable)filtered));
        return filtered;
    }

    @Override
    public List<TimeZoneInfo> getAllTimeZoneInfos(ApplicationUser user) {
        LOGGER.debug("get all time zone infos", new Object[0]);
        return this.timeZoneService.getTimeZoneInfos((JiraServiceContext)new JiraServiceContextImpl(user));
    }
}

