/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.act.StageTaskProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;

class BoundActivitySchedulingProblem
implements BoundAssignmentProblem {
    private final IIntegerInterval interval;
    private final boolean syncStart;
    private final List<StageTaskProblem> subProblems;
    private final PositivePrimitivesMap<IResourceType> overallDemand;
    private final Set<AssignmentResource> overallResources;
    private final int combinations;
    private final List<AssignmentResource> sortedResources;

    BoundActivitySchedulingProblem(IIntegerInterval interval, boolean syncStart, List<StageTaskProblem> subProblems, PositivePrimitivesMap<IResourceType> overallDemand, Set<AssignmentResource> overallResources, int overallCombinations) {
        Preconditions.checkArgument((overallCombinations > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((!subProblems.isEmpty() ? 1 : 0) != 0);
        this.overallDemand = overallDemand;
        this.overallResources = overallResources;
        this.interval = (IIntegerInterval)Preconditions.checkNotNull((Object)interval);
        this.syncStart = syncStart;
        this.subProblems = subProblems;
        this.combinations = overallCombinations;
        this.sortedResources = RmSortableUtils.sort(overallResources);
    }

    @Override
    public Set<AssignmentResource> getAllSkilledResources() {
        return this.overallResources;
    }

    @Override
    public List<AssignmentResource> getAllSkilledResourcesSorted() {
        return this.sortedResources;
    }

    @Override
    public IIntegerInterval getTimeInterval() {
        return this.interval;
    }

    @Override
    public boolean isSyncStart() {
        return this.syncStart;
    }

    @Override
    public List<StageTaskProblem> getStageTaskProblems() {
        return this.subProblems;
    }

    @Override
    public int getCombinatorialCount() {
        return this.combinations;
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getOverallDemand() {
        return this.overallDemand;
    }
}

