/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.EmptyNonWorkingDays;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IsWorkTimeStep;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WeeklyWorkDayDefinition;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;

public class DefaultTimeStepPresenceFunction
implements TimeStepPresenceFunction {
    private final WeeklyWorkDayDefinition weeklyWorkDayFunction;
    private final IsWorkTimeStep isWorkingDayFunction;
    private final float getDefaultDailyHours;

    public DefaultTimeStepPresenceFunction(WeeklyWorkDayDefinition weeklyWorkDayFunction) {
        this(weeklyWorkDayFunction, EmptyNonWorkingDays.INSTANCE, 8.0f);
    }

    public DefaultTimeStepPresenceFunction(WeeklyWorkDayDefinition weeklyWorkDayFunction, IsWorkTimeStep isWorkingDayFunction, float defaultDailyHours) {
        this.weeklyWorkDayFunction = weeklyWorkDayFunction;
        this.isWorkingDayFunction = isWorkingDayFunction;
        this.getDefaultDailyHours = defaultDailyHours;
    }

    @Override
    public boolean getAt(int timeStep) {
        return this.weeklyWorkDayFunction.isWorkTimeStep(timeStep) && this.isWorkingDayFunction.isWorkTimeStep(timeStep);
    }

    @Override
    public boolean isWorkTimeStep(int timeStep) {
        return this.getAt(timeStep);
    }

    @Override
    public int getPresenceSum(IIntegerInterval interval) {
        int sum = 0;
        for (int i = interval.getStart(); i <= interval.getEnd(); ++i) {
            if (!this.getAt(i)) continue;
            ++sum;
        }
        return sum;
    }

    @Override
    public int getWeeklyWorkDays() {
        return this.weeklyWorkDayFunction.getWorkDaysPerWeek();
    }

    @Override
    public boolean isAllDisabled() {
        return this.getWeeklyWorkDays() == 0;
    }

    @Override
    public float getDefaultDailyHours() {
        return this.getDefaultDailyHours;
    }

    @Override
    public float getDefaultWeeklyHours() {
        return this.getDefaultDailyHours * (float)this.getWeeklyWorkDays();
    }
}

