/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.types;

import com.mysema.query.sql.types.AbstractType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class ArrayType<T>
extends AbstractType<T[]> {
    private final Class<T[]> type;
    private final String typeName;

    public ArrayType(Class<T[]> type, String typeName) {
        super(2003);
        this.type = type;
        this.typeName = typeName;
    }

    @Override
    public Class<T[]> getReturnedClass() {
        return this.type;
    }

    @Override
    @Nullable
    public T[] getValue(ResultSet rs, int startIndex) throws SQLException {
        Array arr = rs.getArray(startIndex);
        return arr != null ? (Object[])arr.getArray() : null;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, T[] value) throws SQLException {
        Array arr = st.getConnection().createArrayOf(this.typeName, value);
        st.setArray(startIndex, arr);
    }
}

